IF (NOT AUTOCHECK)

PACKAGE()
OWNER(g:kernel)

SET(VERSION 1.8.3)
SET(SRC_RESOURCE 2407863295)
SET(SRC_TARBALL yandex-iptables-${VERSION}.tar.gz)
SET(OUT_BIN xtables-legacy-multi)

INCLUDE(${ARCADIA_ROOT}/infra/qemu/vmexec/env.inc)

PEERDIR(
    ${QEMU_BIN_ROOT}
    ${VMEXEC_DEF_ROOTFS}
)

FROM_SANDBOX(
    FILE ${SRC_RESOURCE}
    OUT ${SRC_TARBALL}
)

RUN_PROGRAM(
    infra/qemu/vmexec -S ${ARCADIA_ROOT} -B ${ARCADIA_BUILD_ROOT}
                -I ${VMEXEC_DEF_ROOTFS}/rootfs.img --vcpu 8 --mem 8G --
                         build.py build --install-deps ${SRC_TARBALL} ${OUT_BIN}
    CWD ${BINDIR}
    IN build.py
       ${SRC_TARBALL}
       ${QEMU_BIN_APP}
       ${VMEXEC_DEF_ROOTFS}/rootfs.img

    OUT_NOAUTO ${OUT_BIN}
    STDOUT_NOAUTO build.log
)

END()

ENDIF()
#endif
