%{!?deb_version: %define deb_version %{expand:%%(awk -F'"|-' '/version/ {print $4}' pkg-static.json)} }
%{!?release_version: %define release_version %{expand:%%(svn info | awk '/^Last Changed Rev:/ {print $NF}')} }

Summary: Host Based Firewall agent (static build)
Name: yandex-hbf-agent-static
Version: %deb_version
Release: %release_version
License: proprietary
Group: System Environment/Base
Vendor: yandex
Packager: askort@yandex-team.ru
BuildRoot: %_tmppath/%name-%version-%release-root
BuildArch: %{_arch}
URL: https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/packages/yandex-hbf-agent
Requires: iptables
Provides: yandex-hbf-agent
Obsoletes: yandex-hbf-agent
Conflicts: yandex-hbf-agent
Source0: %name.%deb_version-%release_version.tar.gz

%description
Host based firewall agent (static build).

%prep
%setup -c

%install
%{__rm} -rf $RPM_BUILD_ROOT
%{__mkdir} $RPM_BUILD_ROOT
%{__cp} -r etc $RPM_BUILD_ROOT/
%{__rm} -rf $RPM_BUILD_ROOT/etc/update-motd.d
%{__cp} -r usr $RPM_BUILD_ROOT/

%files
%config %{_sysconfdir}/cron.d/hbf-update-ssh-exception
%config %{_sysconfdir}/sudoers.d/yandex-hbf-agent
%config %{_sysconfdir}/yandex-hbf-agent
%{_bindir}/*
%{_sbindir}/*
%{_datadir}/yandex-hbf-agent

%post
U_NAME='hbf'
U_HOME='/var/run/yandex-hbf-agent'
# Create user and group ${U_NAME} if does not exist
if ! getent group ${U_NAME} > /dev/null; then
    groupadd ${U_NAME}
else
    echo "${U_NAME} group already exists."
fi

if ! getent passwd ${U_NAME} > /dev/null; then
    useradd --system --gid ${U_NAME} --shell /bin/false \
            --home-dir ${U_HOME} ${U_NAME}
else
    echo "${U_NAME} user already exists."
fi

%changelog
