%define deb_version %{expand:%%(awk -F'"|-' '/version/ {print $4}' pkg.json)}
%define release_version %{expand:%%(svn info | awk '/^Last Changed Rev:/ {print $NF}')}

Summary: Host Based Firewall agent
Name: yandex-hbf-agent
Version: %deb_version
Release: %release_version
License: proprietary
Group: System Environment/Base
Vendor: yandex
Packager: askort@yandex-team.ru
BuildRoot: %_tmppath/%name-%version-%release-root
BuildArch: noarch
URL: https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/packages/yandex-hbf-agent
Requires: iptables
%if 0%{?el5}
Requires: python26
Requires: python26-ipaddr
Requires: python26-configobj
%else
Requires: python
Requires: python-ipaddr
Requires: python-configobj
%endif
Source: %name.tar.gz

%description
Host based firewall agent.

%prep
%setup -n %name

%install
rm -rf $RPM_BUILD_ROOT
install -d -m 755 $RPM_BUILD_ROOT/etc/yandex-hbf-agent/
install -d -m 755 $RPM_BUILD_ROOT/etc/sudoers.d/
install -m 440 sudoers.d/yandex-hbf-agent $RPM_BUILD_ROOT/etc/sudoers.d/
install -d -m 755 $RPM_BUILD_ROOT/usr/bin/
install -m 755 bin/* $RPM_BUILD_ROOT/usr/bin/
install -d -m 775 $RPM_BUILD_ROOT/usr/lib/python2.7/site-packages/hbfagent/mod
install -m 644 hbfagent/*.py \
        $RPM_BUILD_ROOT/usr/lib/python2.7/site-packages/hbfagent/
install -m 644 hbfagent/mod/*.py \
        $RPM_BUILD_ROOT/usr/lib/python2.7/site-packages/hbfagent/mod/
install -d -m 755 $RPM_BUILD_ROOT/usr/share/yandex-hbf-agent/rules.d/
install share/logging.configspec \
        $RPM_BUILD_ROOT/usr/share/yandex-hbf-agent/
install share/yandex-hbf-agent.configspec \
        $RPM_BUILD_ROOT/usr/share/yandex-hbf-agent/
install share/rules.d/* \
        $RPM_BUILD_ROOT/usr/share/yandex-hbf-agent/rules.d/

%files
%doc README.md
%config /etc/yandex-hbf-agent
%config /etc/sudoers.d/yandex-hbf-agent
/usr/bin/*
/usr/lib/python2.7/site-packages/hbfagent
/usr/share/yandex-hbf-agent

%post
U_NAME='hbf'
U_HOME='/var/run/yandex-hbf-agent'
# Create user and group ${U_NAME} if does not exist
if ! getent group ${U_NAME} > /dev/null; then
    groupadd ${U_NAME}
else
    echo "${U_NAME} group already exists."
fi

if ! getent passwd ${U_NAME} > /dev/null; then
    useradd --system --gid ${U_NAME} --shell /bin/false \
            --home-dir ${U_HOME} ${U_NAME}
else
    echo "${U_NAME} user already exists."
fi

%changelog
