import yaml


class Config:
    def __init__(self, file_name):
        self.config = None
        self.load(file_name)
        assert self.config is not None, 'cannot load config'

    def load(self, config_file):
        with open(config_file) as jsFile:
            self.config = yaml.safe_load(jsFile)

    def __getitem__(self, item):
        return self.config[item]

    def __contains__(self, item):
        return item in self.config
