import gzip


# Packages is a class for reading packages from the Packages index.
class Packages:
    def __init__(self, filePath, open_func=gzip.open):
        self.f = None
        self.f = open_func(filePath, 'rb')

    def __del__(self):
        if self.f is None:
            return
        self.close()

    def Next(self):
        ret = ''
        while True:
            l = self.f.readline()
            if isinstance(l, bytes):
                l = l.decode("utf-8")
            if l == '' or l == '\n':
                return ret
            ret = "{}{}".format(ret, l)
        return ret

    def close(self):
        self.f.close()
