#!/usr/bin/env python

import os
import subprocess
import re
import time

def deb_check():
    monitor_file = "/tmp/.debsums.state"
    if os.path.exists(monitor_file):
        mtime = os.stat(monitor_file).st_mtime
        ntime = time.time()
        if int(ntime) - int(mtime) < 86000:
            return
    cmd = "/usr/bin/dpkg -l"
    all_pkg_list = subprocess.check_output(cmd.split())
    pkg_list = []
    for line in all_pkg_list.split("\n"):
        if line.startswith('ii'):
            pkg_name = line.split()[1]
            # if pkg_name.startswith('yandex') or pkg_name.startswith('iss'):
            if pkg_name.startswith('yandex'):
                pkg_list.append(pkg_name)

    cmd = "debsums -as {}".format(" ".join(pkg_list))
    cmd_out = subprocess.Popen(cmd, shell=True, stderr=subprocess.STDOUT, \
                           stdout=subprocess.PIPE)
    re_skip = re.compile('(.*no md5sums.*|.*Permission.*|.*auth-(master|worker).*)')
    _str = ""
    for line in cmd_out.stdout.read().split("\n"):
        line = line.strip()
        if line == "":
            continue
        if re_skip.match(line):
            continue
        _str += '{},'.format(line)

    with open(monitor_file, 'w') as f:
        if _str == "":
            f.write('0;Ok')
        else:
            f.write('2;{}'.format(_str))


def main():
    deb_check()


if __name__ == '__main__':
    main()
