#!/bin/sh

cpu=0
cpucount=$(nproc)
ether=eth3
reset_af="00ff00ff"

cat /proc/interrupts | grep $ether-TxRx |  sed 's/ \+\([0-9]\+\):.*/\1/' | while read irq; do
    affinity=$(printf %X `echo $((1<<cpu))`)
    cpu=$(( (cpu+2) % cpucount ))
    if [ "$1" = "-r" ];then 
        echo "reseting affinity irq $irq to default 00ff00ff"
        echo $reset_af > /proc/irq/$irq/smp_affinity
    else
        [ "$1" = "-v" ] && echo "irq $irq affinity $affinity"
        echo $affinity > /proc/irq/$irq/smp_affinity
    fi
done
