#!/bin/bash
ulimit -n 8192

BACKUP_DIR="/place/mysql_backup"
DIR_NAME=`date +%y%m%d%H`
REMOTE_BACKUP_PATH="deposito::antivirus/vdb-slave/"
LOG="/var/log/mysql_backup.log"
SECONDS=0
DOTMYCNF="/home/onotole/.my.cnf"
MYCNF="/etc/mysql/my.cnf"
MYCNFFORCE="/etc/mysql/my.cnf"


err()
{
        echo "$*, exiting..." >&2
	tail ${LOG}
        exit 1
}

if [ -f /etc/mysql/my_force.cnf ]; then
	MYCNFFORCE="/etc/mysql/my_force.cnf"
fi

USER=`cat ${DOTMYCNF}|grep -A 2 "mysql]"|grep user|awk '{print $3}'`
PASSWORD=`cat ${DOTMYCNF}|grep -A 2 "mysql]"|grep password|awk '{print $3}'`

mysql --defaults-file="${DOTMYCNF}" -e "" 2>/dev/null
if [ $? -ne 0 ]; then err "Incorrect username or password"; fi

echo `date` >> ${LOG}
#TODO check free space
rm -rf ${BACKUP_DIR}/* >> ${LOG}
mkdir -p ${BACKUP_DIR}/${DIR_NAME} >> ${LOG}

/usr/bin/innobackupex-1.5.1 --defaults-file=${MYCNF} --user=${USER} --password=${PASSWORD} --slave-info --parallel=4 ${BACKUP_DIR}/${DIR_NAME}/ 1>>${LOG} 2>&1

if [ $? -ne 0 ]; then err "ERROR in preparing backup"; fi 

echo "START 2 STEP" >>${LOG}
/usr/bin/innobackupex-1.5.1 --defaults-file=${MYCNFFORCE} --user=${USER} --password=${PASSWORD} --apply-log ${BACKUP_DIR}/${DIR_NAME}/* 1>>${LOG} 2>&1

if [ $? -ne 0 ]; then err "ERROR in apply-log"; fi

rsync -r ${BACKUP_DIR}/${DIR_NAME}/* ${REMOTE_BACKUP_PATH} >>${LOG}

if [ $? -ne 0 ]; then err "ERROR in saving backup on remote server"; fi

SIZE=`du -sh ${BACKUP_DIR}/${DIR_NAME}`

echo "Backup for mysql-slave successfully saved at deposito. Backup's size ${SIZE}. Time of work ${SECONDS} sec"
exit 0
