#!/bin/sh -e

PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin
HOME=/home/backup
TMPDIR=/var/tmp

export PATH HOME TMPDIR


#-- subroutines --------------------------------------------------------

err()
{
	exitval=$1
	shift

	echo 1>&2 "$0: ERROR: $*"
	exit $exitval
}

cleanup()
{
	local _file

	for _file in $dump_file $arch_file; do
		if [ -f $_file ]; then
			rm -f $_file
		fi
	done
}


#-- variables ----------------------------------------------------------

backup_server="ysbackup7.yandex.ru"
rsync_user="backup"
rsync_share="robotmon"
rsync_dir="pg_dump"
rsync_pass="--password-file ${HOME}/.rsync_${backup_server}"
rsync_path="${rsync_pass} ${rsync_user}@${backup_server}::${rsync_share}/${rsync_dir}"

backup_prefix="backup"
backup_name="${backup_prefix}.`date +%s`.bz2"
backup_count=7

thiscmd=`basename $0`

empty_dir="/var/empty"


#-- main ---------------------------------------------------------------

trap 'echo Canceled ..; exit 1' 2
trap cleanup EXIT

dump_file=`mktemp ${TMPDIR}/${thiscmd}.XXXXXXXXXXXX` || \
	err 1 "Can't create temp file."

if ! pg_dumpall -U backup -f $dump_file; then
	err 1 "Can't do run pg_dumpall."
fi

if ! bzip2 $dump_file; then
	err 1 "Can't compress dump file."
fi

arch_file="${dump_file}.bz2"

if ! rsync -a $arch_file ${rsync_path}/${backup_name}; then
	err 1 "Can't save dump on backup server ${backup_server}."
fi

excludes=`rsync --list-only ${rsync_path}/ 2>/dev/null | awk \
	-v prefix=$backup_prefix -v count=$backup_count '
	BEGIN{
		n=0;
	}
	$5 ~ prefix { files[n] = $5; n++; }
	END{
		for (i = --n; i > n - count && i >= 0; i--)
			printf "--exclude=%s ", files[i];
	}'`

if [ -n "${excludes}" ]; then
	if [ ! -d "${empty_dir}" ]; then
		err 1 "Empty dir ${empty_dir} is not found."
	fi

	if ! rsync -r --delete $excludes ${empty_dir}/ ${rsync_path}/; then
		err 1 "Can't clean old backups."
	fi
fi
