#!/usr/bin/env python
# coding: utf-8
import _mysql
import os
import sys
import subprocess
import time
import re
import gzip
import pwd
import logging

sys.path.append(
        os.path.dirname(
            os.path.realpath(
                sys.argv[0]
                )
            )
        )

from bs_sync import rsync_list_tables, load_mark, varnames, read_config

config = read_config()

lcls = locals()
for var in varnames:
    lcls[var] = config[var]
"""
rsync = '/usr/local/bin/rsync'
rsync_wrkdir = '/storage0/bsexport/db/'
mark_file = '/storage0/bsexport/mark'
flight_file = '/storage0/bsexport/flight'
database_path = '/storage0/db/mysql/yabsdb/'
outdata_dir = '/storage0/bsexport/mysql/'
effective_username="logmux"

escabe_characters= ('\n','\\n'),('\t','\\t'),('\r','\\r')
"""

logformat = '%(asctime)-15s %(message)s'
logging.basicConfig(format=logformat)
logger = logging.getLogger('bs_dump')
logger.setLevel(logging.INFO)



os.setreuid(
        pwd.getpwnam(effective_username).pw_uid,
        pwd.getpwnam(effective_username).pw_uid,
        )

#custom_logpath = {}
'''
custom_logpath = {
        'Watch': '/storage0/logs/logmux/bsexport/watch_log',
        }

custom_format_query = {
        'Watch': """
            SELECT
                0,
                WatchID,
                EventTime,
                CounterID,
                ClientIP,
                RegionID,
                UniqID,
                SessID,
                CounterClass,
                BrowserInfo,
                Params,
                UserAgent,
                URL,
                Referer,
                '',
                SourceBit,
                SearchQuery,
                FUniqID,
                XOperaminiPhoneUa,
                XWapProfile,
                WapProfile,
                Profile,
                UpdateTag
            FROM
                %s L;
        """,
        'EventLog': """
        SELECT 
            EventID,
            ShowTime,
            EventTime,
            CounterType,
            SlotID,
            Position,
            UniqID,
            PageID,
            PlaceID
        FROM
            %s L;
        """,

}
'''


dbconn = _mysql.connect(
    host="localhost",
    user="yabsdb",
    db="yabsdb",
    unix_socket="/tmp/mysql.sock",
    )

def dump_table(tablename):
    ts = time.time()
    logtype, dtimestamp = re.match('Rotate([A-Za-z]+)Log([0-9]+).*',
            tablename).groups()
    dbconn.query("""SET time_zone = '+4:00';""")
    dbconn.store_result()
    if custom_format_query.has_key(logtype):
        dbconn.query(custom_format_query[logtype] % \
                tablename)

    else:
        dbconn.query("""
                select * from %s;""" % \
                os.path.basename(tablename))
    #result = dbconn.store_result()
    result = dbconn.use_result()
    r = result.fetch_row()
    nrows = 1
    if custom_logpath.has_key(logtype):
        #print custom_logpath, logtype
        f = open(custom_logpath[logtype], "a+")
    else:
        f = open(os.path.join(outdata_dir, logtype), "a+")
    while r:
        record = r[0]
        """
        outstr = str()
        for field in record:
            for c in escabe_characters:
                try:
                    field.index(c[0])
                    field = field.replace(*c)
                except ValueError:
                    pass
            outstr+=field+'\t'
        f.write(outstr.rstrip('\t')+"\n")
        """
        f.write("\t".join(record)+"\n")
        lastrow = record
        r = result.fetch_row()
        nrows += 1
    f.flush()
    f.close()
    m = open(mark_file, "a+")
    m.write(tablename+"\n")
    m.close()
    try:
        rtime = int(time.strftime("%s", time.strptime(lastrow[ts_field[logtype]], "%Y-%m-%d %H:%M:%S")))
        ltime = int(time.strftime("%s", time.localtime()))
    except ValueError:
        logger.warning("bad time value: %s" % lastrow[ts_field[logtype]])
        ltime = rtime = 0

    
            #(os.path.join(outdata_dir, os.path.basename(fbase))+".tab", 

    for e in (".MYD", ".MYI", ".frm"):
        os.unlink(os.path.join(rsync_wrkdir, tablename+e))
        os.unlink(os.path.join(database_path, tablename+e))

    delay = (time.time() - ts ) / nrows
    rps = float(nrows)/(time.time() - ts )
    logger.info("Table dumped: %s; %08s records; delta: %07s; dpr: %0.7f; rps: %06.3f" % (
        tablename,
        nrows,
        ltime-rtime,
        delay,
        rps,
    ))

if __name__ == '__main__':
    """
    """
    dbconn.query("SHOW TABLES;")
    result = dbconn.store_result()
    r = result.fetch_row()

    olist = []
    while r: 
        olist.append(r[0][0])
        r = result.fetch_row()
    sortkey=lambda v: re.match("[A-Za-z]*([0-9]+)", v).groups()[0]
    olist.sort(key=sortkey)

    f = open(flight_file, "w")
    f.write("\n".join(olist))
    f.flush()

    logger.info('Tables todo: %s' % len(olist))
    for t in olist:
        dump_table(t)


    f.truncate(0)
    f.close()

    dbconn.close()

    # optimize mark
    remote_tables_dict = {}
    for t in enabled_logs:
        for s in rsync_sources:
            remote_tables_dict.update(rsync_list_tables(s, t))
    done_tables = load_mark(mark_file)
    remote_tables = remote_tables_dict.keys()
    remote_tables.sort()
    cleaned_tables = list(set(done_tables).intersection(set(remote_tables)))
    cleaned_tables.sort()
    m = open("/tmp/tmp_mark", "w")
    m1 = open("/tmp/tmp_mark2", "w")
    m.write("\n".join(cleaned_tables))
    m.close()
    m1.write("\n".join(remote_tables_dict.keys()))
    m1.close()
    logger.info('Marks optimized (%s/%s)' % (len(cleaned_tables),len(done_tables)))

