#!/usr/bin/env bash

host=$(hostname -s)

rc_basedir="/Berkanavt/bin/news/rc"
rc_output=""
rc_retcode=1
services=""
service_filter=""
services_to_check=""
stopped_service=""

# Service ports

declare -A service_port

service_port=(\
[news_checker]=2015 \
[skybit_feed_scheduler]=2022 \
[skybit_feed_scheduler_tr]=2023 \
[skybit_feed_scheduler_en]=2024 \
[skybit_feed_parser]=1983 \
[skybit_feed_parser_tr]=1993 \
[skybit_feed_parser_en]=2003 \
[video_feed_processor]=2025 \
[skybit_storage_pusher]=2026 \
[skybit_storage_pusher_tr]=2027 \
[skybit_storage_pusher_en]=2028 \
[skybit_fetcher]=2029 \
[skybit_fetcher_zora]=2030 \
[skybit_html_parser]=2031 \
[images-extractor]=2032 \
[images-avatars-constructor]=2033 \
[logo_fetcher2]=2034 \
[logo_fetcher2_tr]=2035 \
[logo_fetcher2_en]=2036 \
[skybit_meta_archiver]=2017 \
[skybit_meta_archiver_tr]=2016 \
[skybit_meta_archiver_en]=2020 \
[skybit_fetcher_en]=2037 \
[skybit_html_parser_en]=2038 \
[skybit_extlinks_saver]=2039 \
[news-log-center]=2010 \
[video-processor]=2040 \
)

for service in "${!service_port[@]}"
do
    if [ -z "$service_filter" ]; then
        service_filter=$service
    else
        service_filter=$service_filter"|"$service
    fi
done

# Redises

declare -A redis_port

redis_port=(\
[redis-server]=6379 \
[redis-server-meta]=6470 \
[redis-server-queue]=6471 \
[redis-server-queue2]=6473 \
[redis-mfetcher-mynews]=6472 \
)

check_service_status()
{
    local _service_name="$1"
    local _output="NULL"
    _output=$(wget -T 5 -t 1 -q --output-document - "http://127.0.0.1:${service_port[$_service_name]}/info" 2>/dev/null)
    if [ $? -eq 0 ]; then
        local _uptime=$(echo "$_output" | grep 'up-time' | awk -F ':' '{print $2;}')
        local _state=$(echo "$_output" | grep "state" | awk -F ':' '{print $2;}')
        local _tasks_per_minute=$(echo "$_output" | grep 'tasks-per-minute' | awk -F ':' '{print $2;}')
        local _error=0
        if [ "$_uptime" -lt 600 ]; then
            echo "WARNING: ${_service_name} is running for less than 10 minutes!" >/dev/stderr
            _error=1
        fi
        if [ "$_state" != "acive" ]; then
            echo "WARNING: ${_service_name} is not active!" >/dev/stderr
            _error=1
        fi
        if [ "$_tasks_per_minute" -eq 0 ]; then
            echo "WARNING: ${_service_name} is idle!" >/dev/stderr
            _error=1
        fi
        if [ $_error -eq 0 ]; then
            echo "Service ${_service_name} seems OK"
            return 0
        fi
        return 2
    else
        echo "Unable to retrieve information for ${_service_name} !" >/dev/stderr
        return 1
    fi
}

check_redis()
{
    local _redis_port="$1"
    local _redis_instance="$2"
    local _response=$( (echo -ne "ping\r\n"; sleep 1) | nc 127.0.0.1 $_redis_port )
    if [ $? -ne 0 ]; then
        echo "Unable to connect to ${_redis_instance}!" >/dev/stderr
        echo " " >/dev/stderr
        return 1
    elif [ $(echo $_response | grep PONG) ]; then
        echo "Redis $_redis_instance seems alive, got PONG"
        echo " "
        return 0
    else
        echo "Something wrong happened, $_redis_instance says: $_response" >/dev/stderr
        echo " " >/dev/stderr
        return 1
    fi
}

do_service_check()
{
    local _services_to_check="$1"
    for service in $_services_to_check
    do
        check_service_status $service
        if [ $? -eq 0 ]; then
            echo " "
        else
            echo " " >/dev/stderr
        fi
    done
}

if [ $(echo "$host"|egrep "newstorage[0-9]*") ]; then
    echo "This seems to be a storage server"
    rc_output=$($rc_basedir/news-storage-host status)
    rc_retcode=$?
elif [ $(echo "$host"|egrep "nebula[0-9]*") ]; then
    echo "Nebula detected"
    rc_output=$($rc_basedir/news-aux-host status)
    rc_retcode=$?
else
    echo "WTF: I am not supposed to be run on $host, bailing out!"
    exit 1
fi

if [ $rc_retcode -eq 0 ]; then
    echo "Everything seems to be running, now checking services' health..."
    services=$(echo "$rc_output" | awk '{print $1;}')
    services_to_check=$(echo "$services" | egrep -o "$service_filter" | sort -u)
    do_service_check "$services_to_check"
    for redis_instance in "${!redis_port[@]}"
    do
        check_redis ${redis_port[$redis_instance]} $redis_instance
    done
else
    stopped_services=$(echo "$rc_output" | grep "not running" | sed s/' is not running'//g)
    respawned_services=$(echo "$rc_output" | grep "respawned" | sed 's/ was respawned [0-9]* seconds ago/ /g')
    echo "ALERT! A problem has been detected on ${host}: " >/dev/stderr
    for stopped_service in $stopped_services
    do
        echo "$stopped_service is stopped" >/dev/stderr
    done
    for respawned_service in $respawned_services
    do
        echo "$respawned_service has been respawned recently" >/dev/stderr
    done 
    stopped_services_filter=$(echo $stopped_services $respawned_services | sed 's/ /|/g')
    services=$(echo "$rc_output" | awk '{print $1;}' | egrep -v "$stopped_services_filter")
    services_to_check=$(echo "$services" | egrep -o "$service_filter" | sort -u)
    do_service_check "$services_to_check"
    for redis_instance in "${!redis_port[@]}"
    do
        check_redis ${redis_port[$redis_instance]} $redis_instance
    done 
fi
