#!/bin/sh

HH=`hostname -s | cut -c 7-9`

logdir=/tmp/copy_walrus
test -f $logdir || mkdir -p $logdir

if [ -f $logdir/walrusdb_start.lock -o -f $logdir/walrusdb_done.lock ] ; then
   echo "already started" >&2
   exit 1
fi

touch $logdir/walrusdb_start.lock

for I in `ls /Berkanavt/database/yandex/ | grep -v .old`
  do
    test -f $logdir/copy_$I.dst || ( rsync -r --timeout=60 --chmod=a+r /Berkanavt/database/yandex/${I} dech${HH}::freeze/runet/yandex/ && touch $logdir/copy_$I.dst )
done

test -f $logdir/copy_yanddata.dst || ( rsync -r --timeout=60 --chmod=a+r /Berkanavt/dbspider/yanddata dech${HH}::freeze/runet/yanddata && touch $logdir/copy_yanddata.dst ) || ( rm -f $logdir/walrusdb_start.lock && exit 1 )

if [ X`ls $logdir/ | grep -c dst` = X73 ] ; then
  touch $logdir/walrusdb_done.lock
  rcp $logdir/walrusdb_done.lock dech${HH}:/tmp/
fi
