#!/bin/bash

BASEDIR="/Berkanavt/kiwi/data"
MASTERBASE="${BASEDIR}/kwgene"
DUMPED_MASTERBASE_NAME="kwgene.dump"
DUMPED_MASTERBASE="${BASEDIR}/${DUMPED_MASTERBASE_NAME}"
LOGS_DIR="/Berkanavt/kiwi/data/kwgene/log"
RSYNC="/usr/bin/rsync"
TAR_OPTS="tar -czf"
TAR_PREF="tar.gz"
RSYNC_OPTS="-az --timeout=300 --contimeout=60 --bwlimit=25000"
DUMP_SERVER="deposito.search.yandex.net"

if [ -n "${1}" ]; then
        DUMP_SHARE="${1}"
else
        DUMP_SHARE="$(/bin/hostname -s)"
fi

check_exist_master_db()
{
        if ! [ -d $MASTERBASE ]; then
                echo "No master base exist";
                exit 1;
        fi

}

dump_db()
{
	rm -rf $DUMPED_MASTERBASE ${DUMPED_MASTERBASE}.${TAR_PREF}

	if ! cp -r $MASTERBASE $DUMPED_MASTERBASE ; then
		echo "Dump Problems";
		exit 1;
	fi

	cd ${BASEDIR}

	if ! $TAR_OPTS ${DUMPED_MASTERBASE_NAME}.${TAR_PREF} $DUMPED_MASTERBASE_NAME ; then
		echo "Archive problem"
		exit 1;
	fi
}

check_rsync()
{
        if ! [ -f $RSYNC ]; then
                echo "No rsync installed";
                exit 1;
        fi
}

copy_db_to_deposito()
{
    local _date_
      _date_=`date +%F`

	if ! $RSYNC $RSYNC_OPTS ${DUMPED_MASTERBASE}.${TAR_PREF} rsync://${DUMP_SERVER}/${DUMP_SHARE}/${DUMPED_MASTERBASE_NAME}-${_date_}.${TAR_PREF} ;then
		echo "Error copying";
		exit 1;
	fi
}

find ${LOGS_DIR} -mtime +90 -exec rm -rf {} \+ || true

check_exist_master_db
dump_db
check_rsync
copy_db_to_deposito

