#!/usr/bin/env sh

#This script should help with adding and change hosts in DCHP.
#Author: Aleksandr Kurnosov <saku@yandex-team.ru>

#LOCAL FUNCTIONS
##################

filter_param()
{
	echo $* | sed 's/, /\
/g;s/}//g;s/{//g;s/: /=/g;s/"//g; s/\\/"/g; s/\]//g; s/message=/message="/; /message/s/$/"/'|\
     egrep -i '(macaddr=|rcargs=|systype=|message|linux)'
}

check_dhcp_availability()
{
	curl -H "${_curl_header}" -s -k -m ${_timeout} -o /dev/null \
		"http://${dhcp_server}" && dhcp_available="yes"
	if [ -z "${dhcp_available}" ]; then
		printf "${f_b}MESSAGE:${f_n} ${dhcp_server} is not available now/here\n"
		exit 1
	fi
}

check_param()
{
	local _variable_="${1}"
	if [ ${#} -ge 2 ]; then
		shift
		export echo ${_variable_}="$*"
	fi
}

check_mac_valid()
{
	local _macaddr_="${1}"
	if $(echo "${_macaddr_}" |\
	egrep -iq '^([0-9a-fA-F]{2}:){5}[0-9a-fA-F]{2}'); then
		macaddr="${_macaddr_}"
	else
		printf "${f_b}MESSAGE:${f_n} MAC address for host ${hostname} is not \
valid. Please check.\n"
			continue
			return ${error_code}
	fi
}

check_mac()
{
	local _macaddr_="${1}"
	if [ "${#_macaddr_}" -eq 17 ]; then
		check_mac_valid "${_macaddr_}"

	elif [ "${#_macaddr_}" -eq 12 ]; then
		_macaddr_=$(echo "${_macaddr_}" | \
			sed 's/\(..\)\(..\)\(..\)\(..\)\(..\)\(..\)/\1:\2:\3:\4:\5:\6/')
		check_mac_valid ${_macaddr_}
	else
		printf "${f_b}MESSAGE:${f_n} MAC address for host ${hostname} is not\
 valid. Please check.\n"
			continue
			return ${error_code}
	fi
}

check_variables()
{
#Reading arguments

	local _hostname_="${1}"
	if [ ! -z "${2}" ]; then
		local _macaddr_="${2}"
	fi
	if [ ! -z "${3}" ]; then
		local _systype_="${3}"
	else
		local _systype_="${_systype}"
	fi
	if [ ! -z "${4}" ]; then
		local _rcargs_="${4}"
	else
		local _rcargs_="${_rcargs}"
	fi
#Checking hostname FQDN
	if echo ${_hostname_}|grep -q yandex.ru || [ $(echo ${_hostname_} | \
		    awk -F '.' '{print NF-1}') -ge 2 ]; then
	hostname=${_hostname_};
else
	hostname=${_hostname_}.yandex.ru
fi

#Get existing information for <hostname>
	local _request_="$(curl -H "${_curl_header}" -k -f -Ss -m ${_timeout} \
	    "http://${dhcp_server}/dhcp/rpc/gethost" \
	    -d "ident=${hostname}")"
	filter_param  "${_request_}" > ${tmp}

#Check for new host
	if $(grep -q "does not exists" ${tmp}) && [ "$#" -lt 2 ]; then
		#linux_get_info "${hostname}"
		linux_check=$(linux_get_info "${hostname}" | \
			awk '{if ($1 ~ "error") {print $1}}')
		if [ ! -z "${linux_check}" ]; then
			printf "${f_b}MESSAGE:${f_n} Object ${hostname} does not exists \
and script requires 2 or more parameters for adding it\n"
			continue
			return ${error_code}
		else
			linux_configured="True"
		fi
	fi

#Check for linux host
	if $(grep -q "linux" ${tmp}); then
		linux_configured="True"
	fi
#Get mac systype and rcargs from LUI
	if [ "${linux_configured}" = "True" ]; then
		if [ -z "${_macaddr_}" ]; then
			macaddr=$(linux_get_info "${hostname}" | \
				awk '{if ($0 ~ "mac") {split ($2,a,"\"") ;print a[2]}}')
		fi
		if [ -z "${_systype_}" ]; then
			_systype_=$(linux_get_info "${hostname}" | \
				awk '{if ($0 ~ "config") {split ($2,a,"\"") ;print a[2]}}')
		else
			update_config="Yes"
		fi
		if [ -z "${_rcargs_}" ]; then
			_rcargs_=$(linux_get_info "${hostname}" | \
				awk '{if ($0 ~ "action") {split ($2,a,"\"") ;print a[2]}}')
		fi
	fi
	status=$(linux_get_info "${hostname}" | \
		awk '{if ($0 ~ "status") {split ($2,a,"\"") ;print a[2]}}')

#Get variable values (systype and rcargs valid only for FreeBSD)
	if [ ! "${linux_configured}" = "True" ]; then
		eval $(cat ${tmp} | egrep -v '(message|linux)')
	fi
	check_param macaddr ${_macaddr_}
	check_param systype ${_systype_}
	check_param rcargs ${_rcargs_}

#Checking mac-address for validate
	check_mac ${macaddr}

}

send_changes()
{
	local _hostname_="${1}"
	local _macaddr_="${2}"
	local _systype_="${3}"
	shift 3
	local _rcargs_="${*}"

	printf "${f_b}SERVER:${f_n} ${hostname}\n"
	printf "${f_b}STATUS:${f_n} ${status}\n"

	if [ ! -z "${linux}" ] && [ -z "${freebsd}" ]; then
		printf "${f_b}OPERATING SYSTEM:${f_n} Linux\n"
		printf "${f_b}MAC ADDRESS:${f_n} ${_macaddr_}\n"
		printf "${f_b}CONFIG:${f_n} ${_systype_}\n"
		if [ ! -z ${ipv6_only} ]; then
			printf "${f_b}MESSAGE:${f_n} specified ipv6 only host\n"
			linux_host ${_hostname_} ${_macaddr_} ${_systype_} ${_rcargs_}
		else
			linux_host ${_hostname_} ${_macaddr_} ${_systype_} ${_rcargs_}
		fi
	elif [ ! -z "${linux_configured}" ] && [ -z "${freebsd}" ]; then
		printf "${f_b}OPERATING SYSTEM:${f_n} Linux\n"
		printf "${f_b}MAC ADDRESS:${f_n} ${_macaddr_}\n"
		linux_host ${_hostname_} ${_macaddr_} ${_systype_} ${_rcargs_}
		#LUI_actions "action" "${_hostname_}" "${_rcargs_}"
		if [ "${update_config}" = "Yes" ]; then
			LUI_actions "config" "${_hostname_}" "${_systype_}"
		else
			printf "${f_b}CONFIG:${f_n} ${_systype_}\n"
		fi
		if [ -z "${linux_configured}" ]; then
			eval $(grep 'message' "${tmp}")
		fi
		if [ ! -z "${message}" ]; then
			printf "${f_b}MESSAGE:${f_n} ${message}\n"
		fi
		unset linux_configured
	else
		printf "${f_b}OPERATING SYSTEM:${f_n} FreeBSD\n"
		printf "${f_b}MAC ADDRESS:${f_n} ${_macaddr_}\n"
		printf "${f_b}ACTION:${f_n} ${_rcargs_}\n"
		printf "${f_b}CONFIG:${f_n} ${_systype_}\n"
		bsd_host ${_hostname_} ${_macaddr_} ${_systype_} ${_rcargs_}
	fi

	if [ ! -z "${ipmi_reboot}" ]; then
		ipmi_pxe ${_hostname_} | sed 's/<br>/; /g'
	fi
}

linux_get_info()
{
# 	echo "linux_get_info"
# 	echo ${_oauth_token}
	local _hostname_="${1}"

	curl -H "${_curl_header}" -Ss http://${dhcp_server}/api \
		-d "{\"args\": [], \"method\": \"server_get\", \"kwargs\": \
		{\"query\": {\"name\": \"${_hostname_}\"}}}"

#        if [ ! -z "${_oauth_token}" ]; then
#	        curl -Ss http://${dhcp_server}/api -H "Authorization: OAuth ${_oauth_token}" \
#                        -d "{\"args\": [], \"method\": \"server_get\", \"kwargs\": \
#			{\"query\": {\"name\": \"${_hostname_}\"}}}"
#        else
#		curl -Ss http://${dhcp_server}/api \
#			-d "{\"args\": [], \"method\": \"server_get\", \"kwargs\": \
#			{\"query\": {\"name\": \"${_hostname_}\"}}}"
#	fi
}

LUI_actions()
{
	local _field_="${1}"
	local _hostname_="${2}"
	local _arg_="${3}"
	local _result_=""
	if [ "${_field_}" = "action" ]; then

		if [ "${_arg_}" = "force" ]; then
			_result_="INSTALL"
		elif [ "${_arg_}" = "livecd" ]; then
			_result_="WAIT"
		elif [ "${_arg_}" = "autoboot" ]; then
			_result_="BOOT_FROM_HD"
		else
			_result_="${_arg_}"
		fi
		printf "${f_b}ACTION:${f_n} ${_result_}\n"

	elif [ "${_field_}" = "config" ]; then
		_result_="${_arg_}"
		printf "${f_b}CONFIG:${f_n} ${_result_}\n"
	fi

	curl -H "${_curl_header}" -Ss http://${dhcp_server}/api -d "{\"args\": [], \"method\": \
		\"server_update\", \"kwargs\": {\"query\": {\"name\": \
		\"${_hostname_}\"}, \"update\": {\"${_field_}\": \"${_result_}\"}}}"\
		1>/dev/null
}

# linux_host()
# {
# 	local _hostname_="${1}"
# 	local _macaddr_="${2}"
# 	local _systype_="${3}"
# 	local _rcargs_="${4}"

# 	local _request_="$(curl -k -f -Ss -m ${_timeout} \
# 	"http://${dhcp_server}/dhcp/rpc/addhost"\
# 	-d "ident=${_hostname_}&macaddr=${_macaddr_}&linux=on&linux_config=\
# ${_systype_}")"
# 	eval $(filter_param "${_request_}" | grep 'message')
# 	if [ ! -z "${message}" ]; then
# 		printf "${f_b}MESSAGE:${f_n} ${message}\n"
# 	fi
# 	LUI_actions "action" "${_hostname_}" "${_rcargs_}"
# }

linux_host()
{
	local _hostname_="${1}"
	local _macaddr_="${2}"
	local _systype_="${3}"
	local _rcargs_="${4}"

	#local _request_="$(curl -k -f -Ss -m ${_timeout} \
	#"http://${dhcp_server}/dhcp/rpc/addhost"\
	#-d "ident=${_hostname_}&macaddr=${_macaddr_}&linux=on&linux_config=\
	#${_systype_}")"
	local _request_="$(curl -H "${_curl_header}" -Ss http://${dhcp_server}/api -d '{"method": "upsertServer", "kwargs": {"query": {"$or":
		[{"name": "'"${_hostname_}"'"}, {"mac":"'"${_macaddr_}"'"}]
		}, "initial_server":
		{"action": "'"${_rcargs_}"'", "ip": "'"${_ip_}"'",
		"mac": "'"${_macaddr_}"'", "config": "'"${_systype_}"'",
		"name": "'"${_hostname_}"'"}}}' 1>/dev/null)"
	if [ ! -z "${_rcargs_}" ]; then
		LUI_actions "action" "${_hostname_}" "${_rcargs_}"
	fi
}

bsd_host()
{
	local _hostname_="${1}"
	local _macaddr_="${2}"
	local _systype_="${3}"
	shift 3
	local _rcargs_="${*}"
	local _request_="$(curl -H "${_curl_header}" -k -f -Ss -m ${_timeout} \
"http://${dhcp_server}/dhcp/rpc/addhost"\
	    -d "ident=${_hostname_}&macaddr=${_macaddr_}&systype=${_systype_}\
&rcargs=${_rcargs_}")"
	eval $(filter_param "${_request_}" | grep 'message')
	if [ ! -z "${message}" ]; then
		printf "${f_b}MESSAGE:${f_n} ${message}\n"
	fi
}

ipmi_pxe()
{
	local _hostname_="${1}"
	local _request_="$(curl -H "${_curl_header}" -k -f -Ss -m ${_timeout} \
	    "http://${dhcp_server}/dhcp/rpc/ipmireboot"\
	    -d "ident=${_hostname_}")"
	eval $(filter_param "${_request_}")
	printf "${f_b}MESSAGE:${f_n} ${message}\n"
}

remove_host()
{
	local _hostname_="${1}"
	if [ "${freebsd}" = "True" ]; then
		_request_="$(curl -H "${_curl_header}" -k -f -Ss -m ${_timeout} \
	"http://${dhcp_server}/dhcp/rpc/delhost"\
	    -d "ident=${_hostname_}")"
	elif [ "${linux}" = "True" ]; then
		_request_="$(curl -H "${_curl_header}" -Ss http://${dhcp_server}/api -d '{"method":
			"server_delete","args":[],"kwargs":{"query":
			{"name":{"$in":["'"${_hostname_}"'"]}}}}' 1>/dev/null)"
		_exit_code_=$(echo $?)
		if [ "${_exit_code_}" != "1" ]; then
			printf "${f_b}MESSAGE:${f_n} Host was not found in Linux database.\n"
		fi
	else
		# Trying to delete from Linux database
		_request_="$(curl -H "${_curl_header}" -Ss http://${dhcp_server}/api -d '{"method":
			"server_delete","args":[],"kwargs":{"query":
			{"name":{"$in":["'"${_hostname_}"'"]}}}}' 1>/dev/null)"
		_exit_code_=$(echo $?)
		if [ "${_exit_code_}" != "1" ]; then
			printf "${f_b}MESSAGE:${f_n} Host was not found in Linux database. Checking FreeBSD.\n"
			_request_="$(curl -H "${_curl_header}" -k -f -Ss -m ${_timeout} \
		"http://${dhcp_server}/dhcp/rpc/delhost"\
		    -d "ident=${_hostname_}")"
		fi
	fi

	eval $(filter_param "${_request_}" | grep 'message')
	if [ ! -z "${message}" ]; then
		printf "${f_b}MESSAGE:${f_n} ${message}\n"
	fi
}

help()
{
	less <<EndOfHelp
NAME
	$script_name - adds and modify information about hosts in DCHP

SYNTAX
	$script_name [-L][-f][-l][-i][-s systype] <hostname> <mac-address>
	<systype> <rcargs>
	$script_name -h

DESCRIPTION
	Adds or update information about hosts using DHCP api and LUI api.
	Script is based on information from dindin@ wiki page.
	(http://wiki.yandex-team.ru/DenisBarov/dhcpapi/)
	This script can adds or update information about hosts: systype,
	mac-address and rcargs. Also possible reset to host with IPMI.
	Script can also read standart input and manage lists of hosts.

OPTIONS
	-f	Adds flag "FORCE/INSTALL" for rcargs of host. Overwrite rcargs
		as argument.
	-l	Adds flag "LIVECD/WAIT" for rcargs of host. Overwrite rcargs
		as argument.
	-s systype
		Set systype for host. Overwrites systype as argument.
	-r 	rcargs
		Set rcargs for host. It may take more than one value.
		Available values:
				clean,
				init,
				deconstruct,
				label,
				newfs,
				dumps,
				kernels,
				templates,
				packages,
				scripts,
				ldap,
				umount,
				force,
				livecd,
				reboot.

	-i	This option reboot host and set on a one-time PXE-boot.
		Actualy for servers with IPMI.
	-L	Sets Linux - as target operating system. Parameter
		linux_config sets as systype. Rcargs is not need.
	-F	Sets FreeBSD - as target operating system. Using for linux configured
		hosts.
	-D	Removes host from DHCP. Recommended to use with caution.
		Database can be specified by options -F and -L.
	-6	Specified ipv6 only host. Used with -L option only.

EXAMPLES
	Shows existing information about host:
		${script_name} ws26-000.yandex.ru

	Adds or modify host, if it is present:
		${script_name} ws26-000.yandex.ru 00:25:90:0D:74:96 ws-fbsd9 force
	Same as:
		${script_name} -f -s ws-fbsd9 ws26-000.yandex.ru 0025900D7496

	Set "force" flag using existing information:
		${script_name} -f ws26-000.yandex.ru

	Set "force" flag and initiate PXE-boot without full information
	about host:
		${script_name} -fi ws26-000.yandex.ru

	Set Linux installation with config "web-ubuntu-12.04", use existing
	information about host:
		${script_name} -L -s web-ubuntu-12.04 ws26-000.yandex.ru

	Set FreeBSD installation with config "ws-fbsd9", use existing information
	about host:
		${script_name} -F -s ws-fbsd9 ws26-000.yandex.ru

	Set "livecd" flag for list of hosts in YR group using pipe:
		yr +YRGROUP LIST | ${script_name} -l

Oct 15 2012

EndOfHelp
}

##LOCAL VARIABLES
###################

script_name="$(basename ${0})"
_timeout="2"
dhcp_server="setup.yandex-team.ru"
tmp="$(mktemp /tmp/host_args-XXXXX)"
error_code="64"

#colors
f_b='\033[1m'
f_n='\033[0m'
f_ul='\033[4m'
f_f='\033[7m'

#PARSE OPTIONS
################

while getopts "hfDlLFs:o:r:i6" opt; do
	case ${opt} in
	h)
		help
		exit 0
		;;
	s)
		_systype="${OPTARG}"
		;;
	L)
		linux="True"
		;;
	F)
		freebsd="True"
		;;
	D)
		host_delete="True"
		;;
	f)
		_rcargs="force"
		;;
	l)
		_rcargs="livecd"
		;;
	r)
		_rcargs=${OPTARG}
		;;
	i)
		ipmi_reboot="True"
		;;
        o)
		_oauth_token=${OPTARG}
		;;
	6)
		ipv6_only="True"
		;;
	\?)
		exit 1
		;;
	esac
done

shift $((${OPTIND} - 1))

#BASIC CHECKS
###############

if [ -z "${1}" ] && [ -t 0 ]; then
	cat <<EndOfUsage
Requires at least 1 parameter.
Usage:
  ${script_name} [-L][-6][-F][-f][-l][-i][-o oauth_token][-s systype] <hostname> <mac-address>
  <systype> <rcargs>

Use -h for additional help.
EndOfUsage
	exit 1
else
	hostname="${1}"
fi

#Get mac-addres,systype and rcargs
if [ ! -z "${2}" ]; then
	_macaddr="${2}"
fi

if [ -z "${_systype}" ]; then
	_systype="${3}"
fi

if [ -z "${_rcargs}" ]; then
	_rcargs="${4}"
fi

if [ ! -z ${_oauth_token} ]; then
	_curl_header="Authorization: OAuth ${_oauth_token}"
#	_curl_header=${_oauth_token}
else
	_curl_header=""
fi


##SCRIPT BODY
###############

check_dhcp_availability

if [ ! -t 0 ] && [ -z ${hostname} ]; then
	while read host_args; do
		if [ -z "${host_args}" ]; then
			continue
		fi
#newline for readable output
		printf "\n"
		check_variables ${host_args}
		if [ "${host_delete}" = "True" ]; then
			remove_host ${hostname}
		else
			send_changes ${hostname} ${macaddr} ${systype} ${rcargs}
		fi
	done
else
	check_variables ${hostname} ${_macaddr}
	exit_code="$?"
	if [ "${host_delete}" = "True" ] && [ ! "${exit_code}" -eq "${error_code}" ];
	then
		remove_host ${hostname}
	else

		if [ ! "${exit_code}" -eq "${error_code}" ]; then
			send_changes ${hostname} ${macaddr} ${systype} ${rcargs}
		fi
	fi
fi

trap "rm ${tmp}" 0 1 2 15

exit 0
