#!/bin/sh

#Script collect disk usage statistics and write to log
#Author: Igor Mikheenko <affe@yandex-team.ru>
#
#Put it in crontab or /etc/cron.d/du_homes:
#1	2	*	*	2,4,6	root	[ -x /Berkanavt/webscripts/admscripts/scripts/du_homes.sh ] && /Berkanavt/webscripts/admscripts/scripts/du_homes.sh

set -u

#Global variables
timestamp=$(date +"%Y%m%d-%H%M")
root_path="/home"
logfile="du_home.log"
log="/var/log/${logfile}"
tmpfile="/var/tmp/du_home.tmp"

#Need to run as root
if [ "$(whoami)" != 'root' ]; then
        echo "$0 need to run as root."
        exit 1;
fi

#Check tmp file
if [ -f ${tmpfile} ]; then
	cat /dev/null > ${tmpfile}
else
	touch ${tmpfile}
fi

#Rotate log
if [ -f ${log} ]; then
	if [ -f ${log}.0 ]; then
		mv ${log}.0 ${log}.1
		mv ${log} ${log}.0
	else
		mv ${log} ${log}.0
	fi
fi

#Collect disk usage statistics and write to log
echo "${timestamp}" > ${log}
{
	echo
	du -xms /var/tmp/
	echo
} >> ${log}

for user in $(echo /home/* |tr " " "\n"|awk -F"/" '{print $NF}'|sort -u); do
	if [ -d "${root_path}"/"${user}" ]; then
		_home_str=$(du -xms --exclude="${root_path}/${user}/.ya" "${root_path}"/"${user}")
		_home_size=$(expr "${_home_str}" : '\(^[0-9]*\)')
	fi
	_ya_dir="/home/${user}/.ya"
	if [ -d "${_ya_dir}" ]; then
		_ya_file="${_ya_dir}/log/ya_du.log"
		if [ ! -d "${_ya_dir}/log" ]; then
			mkdir "${_ya_dir}/log"
			chown "${user}" "${_ya_dir}/log"
		fi
		if [ ! -f "${_ya_file}" ]; then
			touch "${_ya_file}"
			chown "${user}" "${_ya_file}"
		fi
		printf "%s\n\n" "${timestamp}" > "${_ya_file}"
		_ya_str=$(du -xms "${_ya_dir}")
		printf "%s\n" "${_ya_str}" >> "${_ya_file}"
		_ya_size=$(expr "${_ya_str}" : '\(^[0-9]*\)')
	else
		_ya_size=0
	fi
	_size=$((_home_size + _ya_size))
	printf "%s\t%s/%s\n" "${_size}" "${root_path}" "${user}" >> ${tmpfile}
done

# Remove null homes and sort
sed -i '/^1[^0-9]/d' ${tmpfile}
sort -rn "${tmpfile}" >> ${log}

# Clean
rm -f "${tmpfile}"