#!/bin/sh

#Script collect disk usage statistics of home users
#Put it in crontab or /etc/cron.d/du_homes_mail:
#1	2	*	*	2,4,6	root	[ -x /Berkanavt/webscripts/admscripts/scripts/du_homes_mail.sh ] && /Berkanavt/webscripts/admscripts/scripts/du_homes_mail.sh

set -u

#Global variables
trh_const="75"
trh_const_user="200000"
hostname=$(hostname -f)

#Need to run as root
if [ "$(whoami)" != 'root' ]; then
        echo "$0 need to run as root."
        exit 1;
fi

trh=$(df /home | awk '$5 !~ "Use" {sub("%",""); print $5}')
if [ "$trh" -ge "$trh_const" ]; then
    for user in $(echo /home/* | tr " " "\n" | awk -F"/" '{print $NF}' | sort -u);do
        if [ -d "/home/${user}" ];then
            trh_user=$(du -xms /home/${user} | awk '{print $1}')
            if [ "$trh_user" -ge "$trh_const_user" ]; then
                /usr/sbin/sendmail -t << EOF
From: ${hostname} <kikimr-dev@yandex-team.ru>
To: ${user}@yandex-team.ru
Subject: ${hostname} - User: "${user}" out of space
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Hello.

User "${user}" use to many disk space ${trh_user}M

---
Please check your home. ${hostname}

EOF
            fi
        fi
    done 
fi

# /var/tmp check
TH=5000
POINT="/var/tmp/"
BD=$(du -xmd1 $POINT | awk '{printf $1","; system("stat -c %U "$2"");}')
USRS=$(echo $BD | sed -e "s/ /\n/g" | awk -F ',' '{print $2}' | sort | uniq | grep -v "root")

RES=$(for U in $USRS;do echo $BD|sed -e "s/ /\n/g" | awk -v k=$U -v t=$TH -F ',' '$2 == k {sum += $1} END {if (sum > t) {print k","int(sum/1024)"Gb"}}';done)

for i in $RES;do 
    user=$(echo $i | awk -F ',' '{print $1}')
    space=$(echo $i | awk -F ',' '{print $2}')
    /usr/sbin/sendmail -t << EOF
From: ${hostname} <kikimr-dev@yandex-team.ru>
To: ${user}@yandex-team.ru
Subject: ${hostname} - /var/tmp out of space
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Hello.

/var/tmp use to many disk space under your user ("${space}")

You can find your files using:
find /var/tmp/ -maxdepth 1 -user "${user}"

EOF
done

