#!/usr/bin/env python

"""
This script searchs ECC memory errors on linux. 
If it finds them, it will send e-mail to helpdc@yandex-team.ru
with information about broken memory bank.

Script uses edac kernel module.

NOTE: It can be buggy. Please, send any feedback to olegsenin@yandex-team.ru
"""

import os
import re
import socket
import smtplib
import sys
import urllib2
from email.mime.text import MIMEText

## Global variables

""" Define path to EDAC information"""
work_path = "/sys/devices/system/edac/mc/"

""" Get and set hostname """
hostname = str(socket.gethostname())

""" Server location """
def getServerLocation():
    """ This function gets server location in DC """
    global hostname
    request_link = 'http://ro.admin.yandex-team.ru/api/host_query.sbml?hostname='
    request_link += "%s" % hostname
    request_link += '&columns=dc,rack'

    req = urllib2.Request(request_link)
    try:
        loc_open = urllib2.urlopen(req)
        location = loc_open.read()
    except:
        location = "N/A"
    return location
server_location = str(getServerLocation())

## Functions
def send_mail(mc,csrow):
    """ This function send e-mail to DC with change memory request """
    global hostname, server_location
    sender = "root@%s" % hostname
    to = ['helpdc@yandex-team.ru']
    cc = ['search-maintenance@yandex-team.ru']
    subj = 'ECC memory errors on %s' % hostname

    message = "Hi!\nThere are some ECC memory errors on server: %s" % hostname
    message += "\nPlease, change this bank:\nCPU: %s" % str(mc)[-1]
    message += " Bank: %s" % str(csrow)[-1] 
    message += "\n\n Server location:\n%s" % server_location
    message += "\n-- \nThnx!"

    msg = MIMEText(message, 'plain')
    msg['Subject'] = subj
    msg['From'] = sender
    msg['To'] = ", ".join(to)
    msg['Cc'] = ", ".join(cc)

    try:
        server = smtplib.SMTP('localhost')
        server.sendmail(sender, to + cc, msg.as_string())
        print "Successfully sent email to DC"
        server.quit()
    except smtplib.SMTPException:
        print "Unable to sent e-mail"

def get_mc(work_path):
    """ This function get cpus dirs """
    try:
        mc_list = os.listdir(work_path)
        return mc_list
    except OSError:
        sys.exit("Error! Seems like EDAC module is not loaded.\nCan't continue.")

def get_csrow(work_path):
    """ This function gets list of memory banks dirs """
    try:
        os.chdir(work_path)
        csrow_list = []
        mc_list = get_mc(work_path)
        mc_listdir = os.listdir(mc_list[0])
        for i in range(0, len(mc_listdir)):
            if re.match('^csrow[0-9]+', mc_listdir[i]):
                csrow_list.append(mc_listdir[i])
        return csrow_list
    except OSError:
        sys.exit("Error! Seems like EDAC module is not loaded.\nCan't continue.")

# Workflow
cpus_list = get_mc(work_path)
banks_list = get_csrow(work_path)

for cpu in cpus_list:
    for bank in banks_list:
        ce_fp = open(str(cpu) + "/" + str(bank) + "/ce_count" ).read()
        ue_fp = open(str(cpu) + "/" + str(bank) + "/ue_count" ).read()
        if not re.match('^0$', ce_fp): 
            print "Sending mail to DC about CPU: " + cpu[-1] + " Bank: " + bank[-1]
            send_mail(cpu,bank)
        elif not re.match('^0$', ue_fp):
            print "Sending mail to DC about CPU: " + cpu[-1] + " Bank: " + bank[-1]
            send_mail(cpu,bank)
        else:
            print "No ECC errors on CPU: " + cpu[-1] + " Bank: " + bank[-1]
