#!/usr/bin/env python
# -*- coding: utf-8 -*-

# refs: https://jira.yandex-team.ru/browse/SEARCHADMIN-1560

import urllib2
import socket
import sys
import re

APIURL = 'http://golem.yandex-team.ru/api/firewall/expand_macro.sbml?macro=%s'
MACRO_RE = re.compile('_[A-Z0-9_]+_$')


def host2net(item):
    if '/' in item or ':' in item:
        return [item]
    res = []
    try:
        for i in [i[-1][0] for i in socket.getaddrinfo(item,None,0)
                if isinstance(i[-1][0], basestring)]:
            if ':' in i:
                # skip ipv6
                #res.append(i)
                pass
            else:
                res.append(i)
    except socket.gaierror:
        pass
    return res


def expand_macro(macro):
    f = urllib2.urlopen(APIURL % macro)
    d = f.read()
    assert d.startswith('ok '), 'incorrect golem api answer'
    recursive_expand = lambda x: expand_macro(x) if MACRO_RE.match(x) else x
    res = []
    for i in [i for i in d.split() if i not in 'ok or'.split()]:
        if MACRO_RE.match(i):
            res += expand_macro(i)
        else:
            res += host2net(i)
    return res

if __name__ == "__main__":
    macroses = '''
    _YANDEXNETS_
    _SLBPUBLICSUPERNETS_
    _ARCADIASVN_
    _SPIDERSRV_
    _SPIDERNETS_
    _SEARCHMLSPIDERNETS_
    _MRPROXY01SRV_
    _PERSONALPROJECTNETS_
    '''
    if sys.argv[1:] and MACRO_RE.match(sys.argv[1]):
        print '\n'.join(expand_macro(sys.argv[1]))
    else:
        exit('Usage: %s _MACRONAME_' % sys.argv[0])
#    for m in set(macroses.split()):
#        print '==========', m
#        print '\n'.join(expand_macro(m))
