#!/usr/bin/env bash

# This is blank file for scripts. Contains checks for -h parameters, help functions and sections.
# Author: <author>
# <additonal comment>
#
# You are free to change this script if you're think, it will help other SEARCH admins.
# Please, don't forget to notify searchadm@ for changes.

set -u

##########################
#### GLOBAL VARIABLES ####
##########################



#########################
#### LOCAL VARIABLES ####
#########################

script_name="$(basename $0)"
script_dir="$(dirname $0)"
# Number of required parameters, specified after all options.
required_params=1
# Zone file path.
zone_file=""
# How much IPs to show.
head_lines=1000

#########################
#### LOCAL FUNCTIONS ####
#########################

help () {
	cat <<EndOfHelp | ${PAGER:-less}

NAME
	$script_name - lists IPs not mentioned in domain zone file

SYNOPSIS
	$script_name zone_file [num]

DESCRIPTION
	Generates sequence of numbers from 1 to 255 and diff's it with
	namedb-file As result you have list of 'free' IPs in selected zone (and
	corresponding network, if it has /24 netmask). It can "cut" output by
	NUM head lines.

OPTIONS
	-h	show this help and exit

	-v	be verbose

PARAMETERS
	zone_file
		path to namedb reverse zone file, containing ip addresses of
		some network and hostnamesi of it.

	num	number of "free" IP addresses to be displayed. This option makes
		script to cut n lines from head.


BSD				 April 25, 2012				    BSD

EndOfHelp
}

# Print a short script usage description
reference ()
{
	cat <<EndOfReference

	$script_name requires 1 parameter
	    $script_name zone_file

	For verbose help use -h flag:
	    $script_name -h

EndOfReference
}

. "${script_dir}/messages.sh"

#################################################
#### TESTING OPTIONS, CONFIGURING CURREN RUN ####
#################################################

while getopts "hv" opt; do
	case $opt in
	h)
		help
		exit
		;;
	v)
		msg_verbose_flag=true
		;;
	\:)
		critical 64 "Option -${OPTARG} requires an argument"
		;;
	\?)
		reference
		exit 64
		;;
	esac
done
shift $(($OPTIND - 1))

if [ "$#" -lt "$required_params" ]; then
	reference
	exit 64
fi

#######################
#### SCRIPT'S BODY ####
#######################

zone_file="${1}"

test -r "${zone_file}" \
    || critical 74 "DNS zone file '${zone_file}' not found."
test "$#" -gt "1" \
    && head_lines="${2}"

# List of ALL IP's
temp_all=$(mktemp "/tmp/${script_name}.XXXXXX") \
    || critical 74 "Can't make temp file."
# List of DNS records
temp_records=$(mktemp "/tmp/${script_name}.XXXXXX") \
    || critical 74 "Can't make temp file."

jot 254 1 > "${temp_all}"

verbose "The following IPs seems to be free according to DNS namedb file:"
if ! grep "\bPTR\b" "${zone_file}"; then
    critical 65 "Zone file format error in '${zone_file}'. No 'PTR' records found."
fi > "${temp_records}"

awk '{if ( $1 != "PTR" ) print($1)}' "${temp_records}" \
    | sort -n \
    | diff --left-column "${temp_all}" - \
    | awk '{if ($2 != "") print($2)}' \
    | head -n "${head_lines}"

rm "${temp_all}" "${temp_records}"
