#!/usr/bin/env bash
# Get ssh-keys from CAuth for certain user.

_user="$1"

if [ -z $_user ]; then
	printf "Usage: $(basename $0) <login>\n"
	exit
fi

curl -s --compressed --connect-timeout 60 --max-time 60 \
			--cacert /etc/ldap/certs/cafile.pem \
			http://ldap-dev.yandex.net:4444/userkeys/${_user}/ | \
			grep -v '^#' | sed "s/${_user} : //g"

