#!/usr/bin/env python

import xmlrpclib
import time
import logging

from operator import itemgetter

def retry_function(func, max_tries=10, error_text="", exit_code=1):
    '''
    Calls func with 'max_tries' retries
    '''
    for i in range(1, max_tries + 1):
        try:
            return func()
        except KeyboardInterrupt:
            logging.warning("Recieved KeyboardInterrupt. Exiting...")
            exit(0)
        except BaseException, e:
            logging.error("Action failed, retrying [ %d of %d ]" % (i, max_tries))
            if error_text:
                logging.error(error_text)
            logging.error(e)
        # Incremental failure in case of an error
        time.sleep(i)
    # Negative numbers mean we do not have to exit on error
    if exit_code >= 0:
        exit(exit_code)
    return None

try:
    r = xmlrpclib.ServerProxy("https://sandbox.yandex-team.ru/sandbox/xmlrpc")
    release_filter = {"resource_type": "MIDDLESEARCH_DATA_BUNDLE", "current_releases": True}
    # Trying to get release list from sandbox
    middle_search_bundle = retry_function(lambda: r.listReleases(release_filter),
        error_text="XMLRPC to sandbox failed. Maybe it's MTU/Firewall trouble?", max_tries=3)
    if middle_search_bundle:
        last_middle_search_bundle = sorted(middle_search_bundle, key=itemgetter('id'), reverse=True)[0]
    else:
        logging.error("No current release of SKYNET_PACKAGE found!")
        exit(1)

    # XXX(rbtz@): Clould there be more than one resource? For now assume no.
    for key, value in last_middle_search_bundle['resources'][0].items():
        if isinstance(key, (basestring, int)) and isinstance(value, (basestring, int)):
            print "MSB_{0}={1}".format(key.upper(),value)
except Exception:
    logging.error("Failed to get info from sandbox", exc_info=True)
    exit(1)

exit(0)
