#!/bin/sh
usage()
{
  local _thiscmd

  _thiscmd=$(basename $0)

  echo 1>&2 "Usage: ${_thiscmd} [ -c chart ] [ -h hostgroup ]"\
    "-p profile [ -t timestamp ] [ -z tz ]"
  echo 1>&2 "Options:"
  echo 1>&2 "  -c chart         Chart type (default:" \
    "${default_chart})"
  echo 1>&2 "  -h hostgroup     Host group"
  echo 1>&2 "  -o filename      Output file name (default:" \
    "${default_output_file})"
  echo 1>&2 "  -p profile       Profile (default:" \
    "${default_profile})"
  echo 1>&2 "  -t timestamp     Start time in seconds"\
    "sice epoch (default: ${default_timestamp})" 
  echo 1>&2 "  -g fullTag       fullTag"\
    "golovan_tag (default: ${default_tag})" 
  echo 1>&2 "  -z tz            tz (andremaster me!)"\
    "(default: ${default_tz})" 
  cat 1>&2 <<EOF
examples:
    ${0} -c profile_time_medians -h NMETA -p report-25m -g upper_self
    ${0} -c click_requests -h balancer3-00.yandex.ru -g balancer_custom_self -o balancer3-00.yandex.ru.png
EOF

  exit 1
}

err()
{
  local _exitval

  _exitval=$1
  shift

  echo 1>&2 "$0: ERROR: $*"
  exit $_exitval
}

get_options()
{
  local _opt

  while getopts "c:g:h:o:p:t:z:" _opt; do
    case "$_opt" in
      c) chart="${OPTARG}" ;;
      g) tag="${OPTARG}" ;;
      h) hostgroup="${OPTARG}" ;;
      o) output_file="${OPTARG}" ;;
      p) profile="${OPTARG}" ;;
      t) timestamp="${OPTARG}" ;;
      z) tz="${OPTARG}" ;;
      *) usage ;;
    esac
  done

  shift $(($OPTIND - 1))

  if [ $# -ne 0 ]; then
    usage
  fi
}

check_options()
{
  : ${chart:=${default_chart}}
  : ${tag:=${default_tag}}
  : ${output_file:=${default_output_file}}
  : ${profile:=${default_profile}}
  : ${timestamp:=${default_timestamp}}
  : ${tz:=${default_tz}}

  if [ -z "${hostgroup}" ]; then
    usage
  fi
}

request_screenshot()
{
  local _output_variable _cache_file _random_number _post_string _url_string

  _output_variable="$1"
  shift

  _random_number="$( echo 'import random;print  random.randint(10**13,2*10**13)' | python)"
  _post_string="{\"tz\":${tz},\"data\":[{\"chartType\":\"${chart}\",\"host\":\"${hostgroup}\",\"fullTag\":\"${tag}\",\"timestamp\":${timestamp},\"profile\":\"${profile}\"}]}"
  _url_string=$(wget -O - --quiet --post-data="${_post_string}" "http://golovan.yandex-team.ru/snapshot/?_=${_random_number}" ) || err 1 "failed requesting golovan"

  if [ -z "${_url_string}" ]; then
    err 1 "got empty url while requesting screenshot"
  fi

  eval ${_output_variable}=${_url_string}

}

grep_image_url()
{
  local _output_variable _url_string

  _request_url="$1"
  shift
  _output_variable="$1"
  shift

  # no pipefail in sh
  _url_string=$(wget -O - --quiet "${_request_url}" | grep '<img ' | sed 's/.*\(<img [^>]*\).*/\1/g' | sed "s/.*\(http.*png\).*/\1/g" )

  eval ${_output_variable}=${_url_string}

}

fetch_image()
{
   local _output_file _request_url

  _request_url="$1"
  shift
  _output_file="$1"
  shift

  wget --quiet -O "${_output_file}" "${_request_url}" || err 1 'failed fetching image'
}

default_chart='requests'
default_tag='mmeta_custom_self'
default_output_file='image.png'
default_profile='accesslog-25m' #abs-24h
default_timestamp='0'
default_tz=4

get_options $@
check_options

request_link=''
request_screenshot request_link
image_url=''
grep_image_url $request_link image_url
echo "downloading \"${image_url}\" to \"${output_file}\""
fetch_image $image_url $output_file
