#!/bin/sh -ex

HOST_NAME=`hostname -s`

case $HOST_NAME in

kiwi1[0-1][0-9][0-9]|kiwi12[0-6][0-9])
	case $2 in
	sda|sdb|sdc|sdd|sde|sdf)
	        DSK=`ls /dev/sd[a-f]|grep -v ${2}|head -1`;;
	*)
	        echo "Use start|stop sda|sdb|sdc|sdd|sde|sdf diskname"
	        exit 1;;
	esac
;;
*)
	case $2 in
	sda|sdb|sdc|sdd)
	        DSK=`ls /dev/sd[a-d]|grep -v ${2}|head -1`;;
	*)
	        echo "Use start|stop sda|sdb|sdc|sdd diskname"
	        exit 1;;
	esac
;;
esac

case $1 in

start)
	service kwnest stop || true
	sgdisk --replicate=/dev/${2} ${DSK}
	sleep 1
	sgdisk --randomize-guids --move-second-header /dev/${2}
	grub-install /dev/${2}
	mkfs.ext4 -b 4096 /dev/${2}5
	tune2fs -o journal_data_writeback /dev/${2}5
	mdadm -a /dev/md3 /dev/${2}4
	sleep 1
	mdadm -a /dev/md2 /dev/${2}3
	for i in `cat /etc/fstab |grep UUID|awk '{print $1}'|awk -F '=' '{print $2}'|sort`;do 
		RES=0
	for n in `ls -1 /dev/disk/by-uuid/|sort`;do
		if [ $i = $n ]; then 
		RES=1
		fi
	done
		if [ $RES = 0 ]; then RESULT=$i
		fi
	done 
	if [ ! -z $RESULT ] ; then
		CHANGE=`ls -l --time-style=+%s /dev/disk/by-uuid/|grep ${2}5|awk '{print $7}'`
		sed -i "" -e "s/${RESULT}/${CHANGE}/g" /etc/fstab || true
		sleep 1
	else
		echo "no UUID found to change"
		exit 1
	fi
	if PLACE=`mount -va|grep -v already\ mounted|awk '{print $3}'` ;then
		if [ ! -z "`getent passwd kw`" ]; then 
			KWUSER=kw;
		else 
			KWUSER=kiwitest
		fi
		sleep 1 && cd $PLACE && mkdir kiwi && chown $KWUSER kiwi
	else
		echo "mount problem"
		exit 1
	fi
	service kwnest start || true
	;;
stop)
	mdadm -f /dev/md2 /dev/${2}3 || true
	sleep 1
	mdadm -f /dev/md3 /dev/${2}4 || true
	sleep 1
	mdadm --manage /dev/md2 --remove failed
	sleep 1
	mdadm --manage /dev/md3 --remove failed
	service kwnest stop || true
	sleep 1
	if [ ! -z "`lsof /dev/${2}5`" ] ; then 
	echo "disk in use, killing all";
	fuser -km /dev/${2}5 
	fi	
	umount /dev/${2}5 || true
	service kwnest start || true
	;;
*)
	case $HOST_NAME in

	kiwi1[0-1][0-9][0-9]|kiwi12[0-6][0-9])
	echo "Use start|stop sda|sdb|sdc|sdd|sde|sdf diskname"
	exit 1;;
	*)
	echo "Use start|stop sda|sdb|sdc|sdd diskname"
	exit 1;;
	esac
;;
esac
