#!/bin/sh -ex

disk_chk()
{
        case ${1} in
        sda|sdb|sdc|sdd|sde|sdf)
                ;;
        '')
                echo "disk name is empty"
                exit 1
                ;;
        *)
                echo "${1} bad disk name. plz use sda, sdb, sdc, sdd, sde ,sdf"
                exit 1
                ;;
        esac
}

case $1 in
start)
	DISK=${2}
	disk_chk ${2}
	DSK=`ls /dev/sd[a-d]|grep -v ${2}|head -1`
	for MD in `grep md /proc/mdstat |cut -b 1-3| sort` ;do 
		mdadm /dev/$MD --remove faulty; 
	done
	sgdisk --replicate=/dev/$DISK $DSK ; # fi ;
	sgdisk --randomize-guids --move-second-header /dev/$DISK;
	for MD in `grep md /proc/mdstat |cut -b 1-3`; do 
		last="";
		for disk in `ls /sys/class/block/$MD/slaves/`; do
			B=${disk#sd[a-z]};
			if [ -z $last ]; then last=$B; 
			elif [ $last -ne $B ]; then echo ERROR; fi; 
		done
		N=${disk#sd[a-z]};
		mdadm /dev/$MD -a /dev/$DISK$N;
	done
	grub-install /dev/$DISK
	;;
stop)
        DISK=${2}
        disk_chk ${2}

	for MD in `grep md /proc/mdstat |cut -b 1-3`; do 
		last="";
		for disk in `ls /sys/class/block/$MD/slaves/ `; do 
			B=${disk#sd[a-z]};
			if [ -z $last ]; then last=$B;
			elif [ $last -ne $B ]; then echo ERROR; fi; 
		done
		N=${disk#sd[a-z]};
		if [ -d /sys/class/block/$MD/slaves/$DISK$N ] ;then mdadm /dev/$MD -f /dev/$DISK$N; fi
	done
	sleep 5;
	for MD in `grep md /proc/mdstat |cut -b 1-3| sort` ;do mdadm /dev/$MD --remove faulty; done
	;;
esac
