#!/bin/sh -ex

swap_off()
{
	swapname=`swapinfo | awk '/\/dev\/(da|ad|ada)/ {print$1}' | grep $1`
	echo ${swapname}
	if [ "${swapname}" != "" ]
	then
		swapoff /dev/${1}b
		sleep 2
	fi
}

swap_on()
{
	swapname=`awk '/swap/ {print$1}' /etc/fstab | grep $1`
	if [ "${swapname}" != "" ]
	then
		swapon -a
		sleep 2
	fi
}

disk_chk()
{
	case ${1} in
	da0|da1|da2|da3|ad0|ad1|ad2|ad3|ada0|ada1|ada2|ada3)
		;;
	'')
		echo "disk name is empty"
		exit 1
		;;
	*)
		echo "${1} bad disk name. plz use da0, da1, da2 or da3(ad0,ad1,ad2 or ad3),(ada0,ada1,ada2 or ada3)"
		exit 1
		;;
	esac
}


case $1 in
start)
	DISK=${2}
	disk_chk ${2}
	#swap_off ${2}
	#echo $DISK
	#DISKNUM=`/bin/expr "$DISK" : 'da\([0-9]\{1\}\)'`
	if [ ${DISK} = "da0" ] || [ ${DISK} = "ad0" ] || [ ${DISK} = "ada0" ]
	then
		DISKN=0
	else
		DISKN=`/bin/expr "${2}" : "[ad][ad][a]*\([0-9]\{1\}\)"`
	fi
	DISKNAME=`/bin/expr "${2}" : "\([ad][ad][a]*\)."`
	echo $DISKNAME
	#DISKNUM=0
	if [ $DISKNAME = "da" ] 
	then
		echo WCE: 1 | camcontrol modepage -e -n da -u $DISKN -m 8 -P 3 || true
		#exit 0
		offset=200
		camcontrol negotiate -n da -u $DISKN -O $offset -W 16 -T enable -R 160.000 -a || true
		camcontrol negotiate -n da -u $DISKN -O $offset -W 16 -T enable -R 160.000 -a || true
	fi
	dd if=/dev/zero of=/dev/${2} count=1000
	disklabel -Brw ${2} auto
	if [ X$2 = Xda1 ] || [ X$2 = Xad1 ] || [ X$2 = Xada1 ]
	then
		disklabel ${DISKNAME}0 | awk '$1 != "c:" {print }' | disklabel -B -R ${2} /dev/stdin
	else
		disklabel ${DISKNAME}1 | awk '$1 != "c:" {print }' | disklabel -B -R ${2} /dev/stdin
	fi

	gmirror insert root ${2}a || echo "gmirror remove for ${2} is incomplete"

	if gmirror status swap > /dev/null 2>&1
        then
		gmirror insert swap ${2}b || echo "gmirror remove for ${2} is incomplete"
        fi

	BVAR=`gmirror status var | grep ${DISKNAME} | head -n1 | awk '{print $3}' | xargs -I name expr name : '[a-z]\{2\}[a]*[0-4]\{1\}\([a-z]\)'`
	gmirror insert var ${2}$BVAR || echo "gmirror remove for ${2} is incomplete"

	if gmirror status opt > /dev/null 2>&1
	then
		BOPT=`gmirror status opt | grep ${DISKNAME} | head -n1 | awk '{print $3}' | xargs -I name expr name : '[a-z]\{2\}[a]*[0-4]\{1\}\([a-z]\)'`
		gmirror insert opt ${2}$BOPT || echo "gmirror remove for ${2} is incomplete"
	fi
	if gstripe status opt > /dev/null 2>&1
	then
		OPTMIRR=`gstripe status opt | grep mirror | head -n1 | awk -F/ '{print $3}' | xargs -I name expr name : '\([a-z]*\)[0-9]\{1\}'`
		BOPT=`gmirror status ${OPTMIRR}1 ${OPTMIRR}2 | grep ${DISKNAME} | head -n1 | awk '{print $3}' | xargs -I name expr name : '[a-z]\{2\}[a]*[0-4]\{1\}\([a-z]\)'`
		case ${2} in
		da0|da2|ad0|ad2|ada0|ada2)
			gmirror insert ${OPTMIRR}1 ${2}$BOPT || echo "gmirror remove for ${2} is incomplete"
			;;
		da1|da3|ad1|ad3|ada1|ada3)
			gmirror insert ${OPTMIRR}2 ${2}$BOPT || echo "gmirror remove for ${2} is incomplete"
			;;
		esac
	fi

	if gmirror status place > /dev/null 2>&1
	then
		BPLACE=`gmirror status place | grep ${DISKNAME} | head -n1 | awk '{print $3}' | xargs -I name expr name : '[a-z]\{2\}[a]*[0-4]\{1\}\([a-z]\)'`
		gmirror insert place ${2}$BPLACE || echo "gmirror remove for ${2} is incomplete"
	fi
	if gstripe status place > /dev/null 2>&1
	then
		PLACEMIRR=`gstripe status place | grep mirror | head -n1 | awk -F/ '{print $3}' | xargs -I name expr name : '\([a-z]*\)[0-9]\{1\}'`
		BPLACE=`gmirror status ${PLACEMIRR}1 ${PLACEMIRR}2 | grep ${DISKNAME} | head -n1 | awk '{print $3}' | xargs -I name expr name : '[a-z]\{2\}[a]*[0-4]\{1\}\([a-z]\)'`
		case ${2} in
		da0|da2|ad0|ad2|ada0|ada2)
			gmirror insert ${PLACEMIRR}1 ${2}$BPLACE || echo "gmirror remove for ${2} is incomplete"
			;;
		da1|da3|ad1|ad3|ada1|ada3)
			gmirror insert ${PLACEMIRR}2 ${2}$BPLACE || echo "gmirror remove for ${2} is incomplete"
			;;
		esac
	fi

	swap_on ${2}
	;;

stop)
	disk_chk ${2}
	swap_off ${2} || true
	gmirror status | grep DEGRADED | grep -v grep | awk '{print $1}' | awk -F/ '{print $2}' | xargs gmirror forget
	DISKNAME=`/bin/expr "${2}" : "\([ad][ad][a]*\)."`
	echo $DISKNAME
	gmirror remove root ${2}a || true

        if gmirror status swap > /dev/null 2>&1
        then
		gmirror remove swap ${2}b || true
        fi

	BVAR=`gmirror status var | grep ${DISKNAME} | head -n1 | awk '{print $3}' | xargs -I name expr name : '[a-z]\{2\}[a]*[0-4]\{1\}\([a-z]\)'`
	gmirror remove var ${2}$BVAR || true

	if gmirror status opt > /dev/null 2>&1
	then
		BOPT=`gmirror status opt | grep ${DISKNAME} | head -n1 | awk '{print $3}' | xargs -I name expr name : '[a-z]\{2\}[a]*[0-4]\{1\}\([a-z]\)'`
		gmirror remove opt ${2}$BOPT || true
	fi
	if gstripe status opt > /dev/null 2>&1
	then
		OPTMIRR=`gstripe status opt | grep mirror | head -n1 | awk -F/ '{print $3}' | xargs -I name expr name : '\([a-z]*\)[0-9]\{1\}'`
		BOPT=`gmirror status ${OPTMIRR}1 ${OPTMIRR}2 | grep ${DISKNAME} | head -n1 | awk '{print $3}' | xargs -I name expr name : '[a-z]\{2\}[a]*[0-4]\{1\}\([a-z]\)'`
		case ${2} in
		da0|da2|ad0|ad2|ada0|ada2)
			gmirror remove ${OPTMIRR}1 ${2}$BOPT || true
			;;
		da1|da3|ad1|ad3|ada1|ada3)
			gmirror remove ${OPTMIRR}2 ${2}$BOPT || true
			;;
		esac
	fi

	if gmirror status place > /dev/null 2>&1
	then
		BPLACE=`gmirror status place | grep ${DISKNAME} | head -n1 | awk '{print $3}' | xargs -I name expr name : '[a-z]\{2\}[a]*[0-4]\{1\}\([a-z]\)'`
		gmirror remove place ${2}$BPLACE || true
	fi
	if gstripe status place > /dev/null 2>&1
	then
		PLACEMIRR=`gstripe status place | grep mirror | head -n1 | awk -F/ '{print $3}' | xargs -I name expr name : '\([a-z]*\)[0-9]\{1\}'`
		BPLACE=`gmirror status ${PLACEMIRR}1 ${PLACEMIRR}2 | grep ${DISKNAME} | head -n1 | awk '{print $3}' | xargs -I name expr name : '[a-z]\{2\}[a]*[0-4]\{1\}\([a-z]\)'`
		case ${2} in
		da0|da2|ad0|ad2|ada0|ada2)
			gmirror remove ${PLACEMIRR}1 ${2}$BPLACE || true
			;;
		da1|da3|ad1|ad3|ada1|ada3)
			gmirror remove ${PLACEMIRR}2 ${2}$BPLACE || true
			;;
		esac
	fi

	if [ "$DISKNAME" = "ad" ]; then
		ATAN=$((`echo ${2} | sed -e 's/ad//'`+2))
		atacontrol info ata${ATAN} | grep -q " ${2} " && atacontrol detach ata${ATAN}
	fi
	;;

*)
	echo "Usage: ./`basename $0` (start|stop) (daX|adX|adaX)"
	;;

esac
