#!/bin/sh -x

mountdir="/db"
mounted="mount | grep -q $mountdir"
gslabel="DB"

cron_chk()
{
	cron_pidfile=/var/run/cron.pid
	cron_pid=`cat $cron_pidfile`
	if [ -f $cron_pidfile ] && ps -p $cron_pid > /dev/null
	then
		return 0
	else
		return 1
	fi
}

swap_off()
{
	swapname=`swapinfo | awk '/\/dev\/da/ {print$1}'`
	if [ "/dev/${1}b" = "${swapname}" ]
	then
		swapoff -a
		sleep 2
	fi
}

swap_on()
{
	swapname=`awk '/swap/ {print$1}' /etc/fstab`
	if [ "/dev/${1}b" = "${swapname}" ]
	then
		swapon -a
		sleep 2
	fi
}

disk_chk()
{
case ${1} in
da0|da1|da2|da3)
	;;
'')
	echo "disk name is empty"
	exit 1
	;;
*)
	echo "${1} bad disk name. plz use da0, da1, da2 or da3"
	exit 1
	;;
esac
}

case $1 in
start)
	disk_chk ${2}
	if cron_chk
	then
		echo "cron is running. plz stop him"
		exit 1
	fi
	swap_off ${2}
	DISKNUM=`/bin/expr ${2} : 'da\([0-9]\{1,\}\)'`
	camcontrol rescan 0:$DISKNUM:0
	echo WCE: 1 | camcontrol modepage -e -n da -u $DISKNUM  -m 8 -P 3
	offset=200
	camcontrol negotiate -n da -u $DISKNUM  -O $offset -W 16 -T enable -R 160.000 -a || true
	camcontrol negotiate -n da -u $DISKNUM  -O $offset -W 16 -T enable -R 160.000 -a || true

	dd if=/dev/zero of=/dev/${2} count=1000
	disklabel -Brw ${2} auto
	if [ "${2}" = "da1" ]
	then
		disklabel da2 | awk '$1 != "c:" {print}' | disklabel -B -R ${2} /dev/stdin
	else
		disklabel da1 | awk '$1 != "c:" {print}' | disklabel -B -R ${2} /dev/stdin
	fi

	gmirror insert -v root ${2}a
	gmirror insert -v var ${2}e
	case ${2} in
	da0|da2)
		gmirror insert -v p1 ${2}f || echo "gmirror insert for ${2} is incomplete"
		;;
	da1|da3)
		gmirror insert -v p2 ${2}f || echo "gmirror insert for ${2} is incomplete"
		;;
	esac
	swap_on ${2}
#	#gstripe label -v -s 262144 $gslabel da0d da1d da2d da3d
#	gstripe label -v -s 65536  $gslabel da0d da1d da2d da3d
#	gcache create -b 65536 -s 1048576 $gslabel /dev/stripe/$gslabel
#	newfs -b 65536 -U -o time -g 5242880 -i 200000 -n -m 0 /dev/stripe/$gslabel > /dev/null
#	#tunefs -f 1073741824 -s 128 -n enable -o time /dev/stripe/$gslabel
#	tunefs -f 16777216 -s 256 -n enable -o time /dev/stripe/$gslabel

	zpool create db  da0d da1d da2d da3d || zpool create -f db da0d da1d da2d da3d
	zpool set failmode=continue db
	zfs create db/mapreduce
	zfs create db/coredumps
	zfs create db/phr
    zfs create -o  refreservation=40G db/maptest; zfs set checksum=on db/maptest; zfs set atime=off db/maptest;zfs set copies=1 db/maptest; zfs set compression=off db/maptest
#QUOTA	
	zfs set quota=40G db/maptest
	zfs set quota=435G db/mapreduce
	zfs set quota=15G db/coredumps
	zfs set refquota=424GB db/mapreduce
#end of QUOTA
	mkdir /db/phr/tmp
	chmod 777  /db/phr/tmp
	chmod 777 /db/coredumps
	zfs set checksum=on db/mapreduce
	zfs set atime=off db/mapreduce
	zfs set copies=1 db/mapreduce
	zfs set compression=off  db/mapreduce

#	if [ ! -d /db ]; then mkdir /db; fi
#	mount /db
#	mkdir /db/mapreduce
#	mkdir /db/coredumps
#	mkdir -p /db/phr/tmp
#	chmod 777 /db/coredumps
#	chmod 777 /db/phr/tmp
        chown -R mapreduce /db/mapreduce
        chown -R maptest /db/maptest
        scp sdf350:/mapreduce/mapreduce /mapreduce/
        scp sdf350:/mapreduce/*.sh /mapreduce/
        scp sdf350:/db/maptest/map* /db/maptest/
        scp sdf350:/db/maptest/*.sh /db/maptest/
        mkdir -p /db/maptest/logs
        chown -R mapreduce /mapreduce/*
        chown -R maptest /db/maptest/*
        /etc/rc.d/cron start > /dev/null
        echo "cd /mapreduce && ./mr_start.sh" | su mapreduce
        echo "cd /db/maptest && ./mr_start.sh" | su maptest
	if cron_chk
        then
	else
		echo "plz run cron manualy"
	fi
	;;

stop)
	disk_chk ${2}
	/etc/rc.d/cron stop > /dev/null
	if cron_chk
	then
		echo "cron is still running. plz stop him"
		exit 1
	fi
	swap_off ${2}
	 gmirror status | grep DEGRADED | grep -v grep | awk  '{print $1}' |  awk  -F/ '{print $2}' | xargs gmirror forget
	#if eval $mounted
	#then
	#	umount -f $mountdir
	#else
	#	"$mountdir is not mounted"
	#fi

	#gstripe stop $gslabel
    kill `lsof -t /db/mapreduce` || true
    kill `lsof -t /db/maptest` || true
    kill `lsof -t /db/phr` || true
    zpool destroy db || zpool destroy -f db
	gmirror remove root ${2}a	
	gmirror remove var ${2}e	
	case ${2} in
	da0|da2)
		gmirror remove p1 ${2}f || echo "gmirror remove for ${2} is incomplete"
		;;
	da1|da3)
		gmirror remove p2 ${2}f || echo "gmirror remove for ${2} is incomplete"
		;;
	esac
	echo "Disk ${2} remove"
	camcontrol devlist
	;;

*)
	echo "Usage: ./`basename $0` (start|stop) daX"
	;;
esac
