#!/bin/sh -xue
#
# $Id$
#

. /etc/ya.subr

root_name="root"
var_name="var"
place_name="place"
ssh_cmd="ssh -o UserKnownHostsFile=/dev/null -o GlobalKnownHostsFile=/dev/null -o StrictHostKeyChecking=no -o ConnectTimeout=30"
rsync_cmd="rsync --bwlimit=10000 -av"
image_host="wspm"
rsync_share="/opt/zmimage/${place_name}"
home_file="home.tgz"
yr_cmd="/Berkanavt/bin/scripts/yr"
sync_paths="/Berkanavt/bin /Berkanavt/antispam/bin"
hostname="$(hostname)"
mail_list="olegsenin@yandex-team.ru,search-maintenance@yandex-team.ru,vlegeza@yandex-team.ru"

get_model()
{
	case ${disk_name} in
	da)
		model="$(smartctl -a /dev/${disk} | awk '/Product:/ {print $2}')"
		;;
	ada)
		model="$(smartctl -a /dev/${disk} | awk '/Device Model:/ {print $3,$4}')"
		;;
	esac
}

get_serial()
{
	serial="$(smartctl -a /dev/${disk} | awk '/Serial [Nn]umber:/ {print $3}')"
}

send_by_bot()
{
	local _result 
	
	get_model
	get_serial

	if [ -z "${serial}" ] ; then
		serial="N-A"
	fi
	if [ -z "${model}" ] ; then
		model="N-A"
	fi

	## Cant't use tabs here, because it inserts spaces in url.
	if ! _result="$(fetch -q -o - \
"http://bot.yandex-team.ru/api/request.php?initiator=search&\
operation=hdd&\
email=yes&\
replyto=${mail_list}&\
name=${hostname}&\
option=changeanalog&\
slot=${disk_num}&\
model=${model}&\
serial=${serial}")" ; then
		echo "Can't send requset - something wrong with bot: ${_result}"
		return 1
	fi

	if is_number ${_result} ; then
		echo "Task number: ${_result}"
		return 0
	else
		echo "Bot returned value, that is not number: ${_result}"
		return 1
	fi
	
}

send_by_mail()
{
	## Autosend mail, when removing disk if send_by_bot() failed.

	sendmail -t << EOF
From: "${hostname}" <seek-hw@yandex-team.ru>
To: helpdc@yandex-team.ru
Cc: ${mail_list}
Reply-To: ${mail_list}
Subject: "${hostname}" - replace disk
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Hello.
Please replace disk ${disk_num} from 0 in server:
`
fetch -q -o - \
	"http://ro.admin.yandex-team.ru/api/host_query.sbml?hostname=${hostname}&columns=name,dc,rack"
`

Check disk by activity and by serial number.

Disk info:
`
case "${disk_name}" in
	da)
		camcontrol inquiry "${disk}" || true
		;;
	ada)
		camcontrol identify "${disk}" | grep -E "^(device model|serial number)" || true
		;;
	ad)
		atacontrol cap "${disk}" | grep -E "^(device model|serial number)" || true
		if atacontrol info ata$((${disk_num} + 2)) | grep -q "^Master:  ${disk} "; then
			if ! atacontrol detach ata$((${disk_num} + 2)); then
				log_err "${_func}: can't detach disk"
			fi
		fi
		;;
esac
`

Thanks.
-- 
This is automated mail from "${hostname}"

EOF
}

log_err()
{
	echo "$*, exit..." >&2
	exit 1
}

usage()
{
	local _basename

	_basename="$(basename $0)"
	log_err "usage: ${_basename} (create|start|stop) (daN|adaN|adN)"
}

check_disk()
{
	local _func
	_func="check_disk"

	case "${disk}" in
	da[0-5]|ada[0-5]|ad[0-5])
		;;
	*)
		log_err "${_func}: \"${disk}\" bad disk name. Use da[0..5], ada[0..5] or ad[0..5]"
		;;
	esac
}

prepare_disk()
{
	local _func _size _size_1 _size_2 _size_3 _size_4 _size_5
	_func="prepare_disk"

	if ! dd if=/dev/zero of=/dev/${disk} count=2; then
		log_err "${_func}: can't clean disk: ${disk}"
	fi

	gpart create -s gpt ${disk}

	case "${disk_name}" in
	da)
		_size=$(gpart show ${disk} | awk '{if ($1 == "=>") print $3}')
		_size_1=$(gpart show ${good_disk} | awk '{if ($3 == 1) print $2}')
		_size_3=$(gpart show ${good_disk} | awk '{if ($3 == 3) print $2}')
		_size_4=$(gpart show ${good_disk} | awk '{if ($3 == 4) print $2}')
		_size_5=$(gpart show ${good_disk} | awk '{if ($3 == 5) print $2}')
		_size_2=$((${_size} - ${_size_1} - ${_size_3} - ${_size_4} - ${_size_5}))

		gpart add -s ${_size_1} -i 1 -t freebsd-boot ${disk}
		gpart add -s ${_size_2} -i 2 -t freebsd-swap ${disk}
		gpart add -s ${_size_3} -i 3 -t freebsd-zfs ${disk}
		gpart add -s ${_size_4} -i 4 -t freebsd-zfs ${disk}
		gpart add -s ${_size_5} -i 5 -t freebsd-zfs ${disk}
		;;
	ada|ad)
		eval `gpart show ${good_disk} | \
		    awk -v d=${disk} '{if (NF == 5) printf("gpart add -s %d -i %d -t %s %s;\n", $2, $3, $4, d)}'`
		;;
	esac

	gpart bootcode -b /boot/pmbr -p /boot/gptzfsboot -i 1 ${disk}
}

prepare_data()
{
	local _func _path _host
	_func="prepare_data"

	if ! cd "/${place_name}"; then
		log_err "${_func}: can't change dir: \"${place_name}\""
	fi

	if ${rsync_cmd} -e "${ssh_cmd}" "${image_host}.fb:${rsync_share}/" .; then
		true
	elif ${rsync_cmd} -e "${ssh_cmd}" "${image_host}:${rsync_share}/" .; then
		true
	else
		log_err "${_func}: can't rsync \"${place_name}\" with ${image_host}"
	fi

	if ! tar -xvf ${home_file}; then
		log_err "${_func}: can't untar ${home_file}"
	fi

	if ! rm ${home_file}; then
		log_err "${_func}: can't remove ${home_file}"
	fi

	mkdir -p -m 0775 `dirname ${yr_cmd}`
	if ! ${rsync_cmd} -e "${ssh_cmd}" "${image_host}:${yr_cmd}" ${yr_cmd}; then
		log_err "${_func}: can't rsync \"${yr_cmd}\" with ${image_host}"
	fi

	_host=$(${yr_cmd} +ZM -`hostname -s` LIST | sort | head -1)
	if [ -z "${_host}" ]; then
		log_err "${_func}: can't get host for syncing"
	fi

	for _path in ${sync_paths}; do
		mkdir -p -m 0775 "${_path}"
		cd "${_path}"

		if ${rsync_cmd} -e "${ssh_cmd}" "${_host}.fb:${_path}/" .; then
			true
		elif ${rsync_cmd} -e "${ssh_cmd}" "${_host}:${_path}/" .; then
			true
		else
			log_err "${_func}: can't rsync \"${_path}\" with ${_host}"
		fi
	done

	_path="/Berkanavt/communism"
	mkdir -p -m 0775 "${_path}"
	cd "${_path}"

	if ${rsync_cmd} --exclude solver.out -e "${ssh_cmd}" "${_host}.fb:${_path}/" .; then
		true
	elif ${rsync_cmd} --exclude solver.out -e "${ssh_cmd}" "${_host}:${_path}/" .; then
		true
	else
		log_err "${_func}: can't rsync \"${_path}\" with ${_host}"
	fi

	/Berkanavt/webscripts/admscripts/scripts/install-latest-skynet.py
}

create_place()
{
	local _func
	_func="create_place"

	prepare_disk

	if ! zpool create ${place_name} raidz ${disk_name}0p5 ${disk_name}1p5 ${disk_name}2p5 ${disk_name}3p5; then
		zpool create -f ${place_name} raidz ${disk_name}0p5 ${disk_name}1p5 ${disk_name}2p5 ${disk_name}3p5
	fi

	prepare_data
}

start_disk()
{
	local _func
	_func="start_disk"

	case "${disk_name}" in
	da)
		camcontrol rescan all || true
		echo WCE: 1 | camcontrol modepage -n ${disk_name} -u ${disk_num} -e -m 8 -P 3 || true
		camcontrol negotiate -n ${disk_name} -u ${disk_num} -O 200 -W 16 -T enable -R 160.000 -a || true
		;;
	ada)
		true
		;;
	ad)
		if ! atacontrol info ata$((${disk_num} + 2)) | grep -q "^Master:  ${disk} "; then
			if ! atacontrol attach ata$((${disk_num} + 2)); then
				log_err "${_func}: can't attach disk"
			fi
		fi
		;;
	esac

	prepare_disk

	gmirror status | grep swap && gmirror insert swap ${disk}p2
	zpool attach ${root_name} ${good_disk}p3 ${disk}p3
	zpool attach ${var_name} ${good_disk}p4 ${disk}p4
	zpool replace ${place_name} ${disk}p5
}

stop_disk()
{
	local _func
	_func="stop_disk"

	gmirror remove swap ${disk}p2 || true
	zpool detach ${root_name} ${disk}p3 || true
	zpool detach ${var_name} ${disk}p4 || true
	zpool offline ${place_name} ${disk}p5 || true

	if ! send_by_bot ; then
		send_by_mail
	fi
}

if [ "$#" -eq 2 ]; then
	disk="$2"				# disk=da0
	check_disk

	disk_name="${disk%[0-9]}"		# disk_name=da
	disk_num="${disk#${disk_name}}"		# disk_num=0
	
	good_num=$(($((${disk_num} + 1)) % 4))	# good_num=1
	good_disk="${disk_name}${good_num}"	# good_disk=da1

	case "$1" in
	create)
		create_place
		;;
	start)
		start_disk
		;;
	stop)
		stop_disk
		;;
	*)
		usage
		;;
	esac
else
	usage
fi
