#!/usr/bin/env python

import sys
import getopt
import json
import os
import socket
import re
from subprocess import Popen, PIPE


# JSON template
template_dict = {
    "macaddr": "00:00:00:00:00:00",
    "hostname": None,
    "targetdir": None,
    "dhcp": {
        "parentpath": "/place/nalivki/FreeBSD/main/",
        "parentserv": "95.108.151.250",
        "type": None,
        "rcargs": "force"
    }
}

rc_conf_local_template="""#
jail_%s_rootdir="%s"
jail_%s_hostname="%s"
jail_%s_ip="%s"
jail_%s_ip_multi0="%s"
jail_%s_ip_multi1="%s"
"""

arg_dict = {
        'p': ['jail path', None],
        'n': ['jail hostname', None],
        'c': ['config type', None],
        'a': ['jail alias', 'Empty'],
}

def help():
    print 'Usage: %s %s' % (sys.argv[0], " ".join("-"+k+" <%s>" % v[0] for k,v in arg_dict.items()))
    sys.exit(1)

try:
    for e in getopt.getopt(sys.argv[1:], "".join( k+":" for k in  arg_dict.keys()))[0]:
        arg_dict[e[0].lstrip("-")][1] = e[1]
except getopt.GetoptError:
    help()

if None in [ v[1] for v in arg_dict.values()]:
    help()

template_dict["hostname"] = arg_dict['n'][1]+".yandex.ru"
if template_dict["hostname"] == socket.gethostname():
    print "ERROR: You can not use parent system's hostname as jail hostname"
    sys.exit(1)
template_dict["targetdir"] = os.path.join(arg_dict['p'][1], arg_dict['n'][1])
template_dict["dhcp"]["type"] = arg_dict['c'][1]

jail_alias = arg_dict['n'][1]
try:
    jail_ipaddr = socket.gethostbyname(template_dict["hostname"])
    if jail_ipaddr == socket.gethostbyname('any.yandex.ru'):
        raise socket.gaierror
except socket.gaierror:
    print "ERROR: Host %s hasn't valid DNS record" %  template_dict["hostname"]
    sys.exit(1)

if arg_dict['a'][1] == 'Empty':
    if template_dict["hostname"].find('-') >= 0:
        jail_alias = jail_alias.replace("-","")
else:
    jail_alias = arg_dict['a'][1]

jail_iface = None
iflist = Popen(['/sbin/ifconfig', '-lu'], stdout=PIPE).communicate()[0].split()
for i in iflist:
    ifstatus = Popen( ['/sbin/ifconfig', i, 'inet'],
            stdout=PIPE).communicate()[0].split('\n')
    iplist = list()
    for l in ifstatus:
        match = re.match('.*inet ([0-9\.]+).*', l)
        if match:
            iplist.append(match.groups()[0])

    if jail_ipaddr in iplist:
        jail_iface = i
        break

if not jail_iface:
    print "ERROR: No valid ip-address %s for hostname %s on any interfaces" % (
            jail_ipaddr,
            template_dict["hostname"],)
    sys.exit(1)

try:
    jail_ipv6addr_fb = socket.getaddrinfo(arg_dict['n'][1]+".fb.yandex.ru", None)[0][4][0]
except socket.gaierror:
    print "ERROR: No DNS record for %s" % arg_dict['n'][1]+".fb.yandex.ru"
    sys.exit(1)

try:
    jail_ipv6addr_bb = socket.getaddrinfo(arg_dict['n'][1]+".search.yandex.net", None)[0][4][0]
except socket.gaierror:
    print "ERROR: No DNS record for %s" % arg_dict['n'][1]+".search.yandex.net"
    sys.exit(1)

j = open("/tmp/jailbuilder.json","w")
json.dump(template_dict,j)
j.close()

rcf = open("/etc/rc.conf.d/jails/%s" % arg_dict['n'][1],"w")

rcf.write(rc_conf_local_template % (
        jail_alias, template_dict["targetdir"],
        jail_alias, template_dict["hostname"],
        jail_alias, jail_ipaddr,
        jail_alias, jail_ipv6addr_fb,
        jail_alias, jail_ipv6addr_bb,
        ))

rcf.close()

if not os.path.exists(os.path.join(arg_dict['p'][1], arg_dict['n'][1])):
    os.mkdir(os.path.join(arg_dict['p'][1], arg_dict['n'][1]))
p = Popen("/place/nalivki/rc local init " +
        "localdata=/tmp/jailbuilder.json dumps  templates " +
        "packages scripts umount" , shell=True, )
p.communicate()
p = Popen("/etc/rc.d/jail restart %s" % arg_dict['n'][1], shell=True)
