import os, sys, subprocess, socket, stat, fcntl, time
from optparse import OptionParser

DELETE_OLD_FILES=7 * 24 * 3600 # secs of age
MAX_DISK_USAGE=10 * 1024 * 1024 * 1024

class ExNoBsconfig(Exception):
    pass

def listPorts(watchedTags, combatOnly):
    hostname = socket.gethostname().split('.', 1)[0]
    devnull = open('/dev/null', 'w')
    try:
        sp = subprocess.Popen(["/db/bin/bsconfig",
                               "listtags", "--yasm-format", "--local"],
                              stdout=subprocess.PIPE, stderr=devnull,
                              close_fds=True)
    except OSError, err:
        print >> sys.stderr, "bsconfig not found"
        if hasattr(err, "traceback"):
            print >> sys.stderr, getattr(err, "traceback")
        else:
            print >> sys.stderr, err
        raise StopIteration()
    if not sp or not sp.stdout:
        print >> sys.stderr, "bsconfig not found"
        raise StopIteration()
    for line in sp.stdout:
        parts = line.rstrip().split()
        instance = parts.pop(0)
        if combatOnly and "ctype_prod" not in set(parts):
            continue
        tags = list(set(parts) & set(watchedTags))
        if len(tags) == 0:
            continue
        iparts = instance.split('@')
        if len(iparts) != 2:
            continue
        hostport = iparts[0].split(":")
        if len(hostport) != 2:
            continue
        yield hostname, hostport[1], iparts[1], tags[0]

# conf - instance directory name
# tag - "int-production" or "mmeta-production"
def runEvlogSample(host, port, conf, tag):
    if "mmeta" in tag:
        tag = "mmeta"
    elif "int" in tag:
        tag = "int"
    else:
        return
    logfullname = "/usr/local/www/logs/current-eventlog-%s-%s" % (tag, port)
    if not os.path.exists(logfullname) or not os.path.isfile(logfullname):
        return
    progargs = [SAMPLE_DIR, logfullname, port]
    progpath =\
        "/db/bsconfig/configinstall/%s/%s:%s/evlog-sample" % (conf, host, port)
    devnull = open('/dev/null', 'w')
    try:
        sp = subprocess.Popen(
            [progpath] + progargs, close_fds=True, stderr=devnull)
    except OSError:
        print >> sys.stderr, "evlog-sample not found"
        return
    sp.wait()

def clearSampleDir():
    sortlist = []
    for root, dirs, files in os.walk(SAMPLE_DIR):
        for filename in files:
            if not filename.startswith('evlogsample-'):
                # do not delete not evlogsample files
                continue
            fullname = root + "/" + filename
            statvalues = os.stat(fullname)
            if (time.time() - statvalues.st_mtime > DELETE_OLD_FILES or
                filename.startswith('evlogsample-tmp-')):
                try:
                    os.unlink(fullname)
                except:
                    print >> sys.stderr, "could not delete too old file: " +\
                        fullname
            sortlist.append((statvalues.st_mtime, statvalues.st_blocks,
                             fullname))
    sortlist.sort()
    sumdu = sum([x[1] for x in sortlist])
    while sumdu > MAX_DISK_USAGE:
        diff, deletefilename = sortlist[0][1:3]
        try:
            os.unlink(deletefilename)
            sumdu -= diff
            sortlist.pop(0)
        except:
            print >> sys.stderr, "could not delete file: " + deletefilename

def main():
    os.nice(100)

    usage = '''Usage: %prog [options] <tags> <position> <directory>
tags\tTags to monitor
position\tPosition of word in tag which shows instance type
directory\tDirectory to store samples'''
    parser = OptionParser(usage=usage)
    parser.add_option('-c', '--combat-only', dest='combat', default=False,
        action='store_true',
        help='Watch only instances with ctype_prod')

    (options, args) = parser.parse_args()
    if len(args) != 3:
        parser.print_help()
        return

    global SAMPLE_DIR
    SAMPLE_DIR = args[2]

    if not os.path.exists(SAMPLE_DIR):
        # ugly hack because of weird os.path.split
        parent_dir = os.path.join(SAMPLE_DIR, "nothing")
        parent_dir = os.path.split(parent_dir)[1]
        parent_dir = os.path.split(parent_dir)[1]
        if not os.path.exists(parent_dir):
            # dir for temp file was not mounted,
            # the error occur to frequently, silently exit
            return
        try:
            os.mkdir(SAMPLE_DIR)
        except:
            print >> sys.stderr, "could not create " + SAMPLE_DIR
            return

    if not os.path.isdir(SAMPLE_DIR):
        print >> sys.stderr, "is not directory: " + SAMPLE_DIR
        return

    try:
        os.chmod(SAMPLE_DIR, stat.S_IRWXU | stat.S_IRWXG | stat.S_IRWXO)
    except OSError: pass

    try:
        lockfile = open(SAMPLE_DIR + "/evlog-sample-lock", "w+")
    except:
        print >> sys.stderr,\
            "could not create lock " + SAMPLE_DIR + "/evlog-sample-lock"
        return

    try:
        fcntl.lockf(lockfile.fileno(), fcntl.LOCK_EX | fcntl.LOCK_NB)
    except:
        return

    clearSampleDir()

    for host, port, conf, tag in listPorts(args[0].split(), options.combat):
        runEvlogSample(host, port, conf, tag)

if __name__ == "__main__":
    main()
