#!/usr/bin/env sh

#This script should help with generating tickets for helpdesk.
#Author: Aleksandr Kurnosov <saku@yandex-team.ru>

#LOCAL FUNCTIONS
##################

get_kvm()
{
	local _comment_ _current_kvm_
	_comment_="${1}"
	_current_kvm_="$(curl -k -f -sS "${bot_api}/kvm.php?name=${_hostname_}")"

	if [ "${_current_kvm_}" = "FAILED" ] || [ "${force_mode}" = "True" ]; then
		if [ "${host_ipmi}" = "True" ];
		then
			printf "${f_b}IPMI:${f_n}	http://${_hostname_}.ipmi.yandex-\
team.ru\n"
			printf "${f_b}GOLEM:${f_n}	https://golem.yandex-team.ru/lau\
nch-ipmi.sbml?h=${_hostname_}\n"
		else
			if [ "${read_only}" = "True" ]; then
				echo "To server ${_hostname_} in not connected KVM. Need to \
send a request"
			else
				printf "${f_b}ACTION:${f_n}	KVM request.\n"
				if [ "${sendmail_use}" = "True" ]; then
					sendmail -t <<EndOfMessage
From: ${email_from}
To: ${email_to}
Cc: ${email_cc}
Reply-To: ${email_replyto}
Subject: [${_host_dc_}/${_host_rack_}-${_host_rack_unit} : KVM : \
${_host_inv_number}] Подключить/проверить актуальность КВМ к машинке \
    ${_hostname_}
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Добрый день.
Сервер ${_hostname_}.
Прошу подключить/проверить на актуальность КВМ
`if [ "${reboot}" = "yes" ]; then
echo -n  "и перезагрузить сервер по кнопке"
fi
if [ -n "${_comment_}" ]; then
	echo "\nКомментарий:\n${_comment_}."
fi
`

Спасибо.

${signature}
EndOfMessage
echo "Request sent via sendmail.\n"
				else
					task_number=$(curl -k -f -sS \
	    "${bot_api}/request.php?name=${_hostname_}&initiator=${initiator}&\
operation=kvm&email=yes&reboot=${reboot}&oauth_token=${token}&boot=${boot}\
&replyto=${email_replyto}&cc=${email_cc}&needcall=${needcall}&\
comment=${_comment_}")

					printf "${f_b}BOT:${f_n}	${task_number}\n"
					otrs_number="$(curl -k -f -Ss  "${bot_api}/status.php?\
id=${task_number}&out=json" | sed 's/"//g; s/}//g' | awk \
'{split($0,a,"OtrsNum:"); print a[2]}')"
					printf "${f_b}OTRS:${f_n}	${otrs_number}\n"
				fi
			fi
		fi
	else
		_host_kvm="$(echo "${_host_dc_short_}-$(echo ${_current_kvm_} | \
			    awk '{print $2}')" |tr '[a-z]' '[A-Z]')"
		printf "${f_b}KVM:${f_n}	${_host_kvm}\n"
		printf "${f_b}GOLEM:${f_n}	https://golem.yandex-team.ru/launch-kvm.\
sbml?kvm=${_host_kvm}\n"

	fi
}

req_hdd()
{
	local _slot_="${1}"
	local _comment_="${2}"
	printf "${f_b}ACTION:${f_n}	HDD request.\n"
	task_number=$(curl -k -f -sS \
		"${bot_api}/request.php?name=${_hostname_}&initiator=${initiator}&\
operation=hdd&slot=${_slot_}&reboot=${reboot}&oauth_token=${token}&boot=${boot}&email=yes\
&replyto=${email_replyto}&cc=${email_cc}&needcall=${needcall}&\
comment=${_comment_}")

	printf "${f_b}BOT:${f_n}	${task_number}\n"
	otrs_number="$(curl -k -f -Ss  "${bot_api}/status.php?id=${task_number}&\
out=json" | sed 's/"//g; s/}//g' | awk '{split($0,a,"OtrsNum:"); print a[2]}')"
	printf "${f_b}OTRS:${f_n}	${otrs_number}\n"

}

req_shelf_hdd()
{
	local _slot_="${1}"
	local _shelf_disk_serial_="${2}"
	local _comment_="${3}"
	local _shelf_inv_ _storage_list_ _storage_info_
	printf "${f_b}ACTION:${f_n}	HDD SHELF request.\n"
	_serial_=$(echo ${_shelf_disk_serial_} | tail -c 9)
	_storage_list_="$(curl -k -s ${bot_api}/storages-by-serverinv.php?\
inv=${_host_inv_number})"
	for storage in ${_storage_list_}; do
		if [ "${storage}" = "NO" ]; then
			echo  "To server ${_hostname_} is not connected shelf-storage."
			break
		elif [ "${storage}" = "YES" ]; then
			continue
		fi
		_shelf_inv_="${storage}"
		_storage_info_="$(curl -k -s bot.yandex-team.ru/api/consistof.php?\
inv=${_shelf_inv_})"
		for line in ${_storage_info_}; do
			if $(echo "${line}" | grep -q "${_serial_}" ); then
				task_number=$(curl -k -f -sS \
		"${bot_api}/request.php?inv=${_shelf_inv_}&initiator=${initiator}&\
operation=hdd&slot=${_slot_}&reboot=${reboot}&oauth_token=${token}&boot=${boot}&email=yes\
&replyto=${email_replyto}&cc=${email_cc}&needcall=${needcall}\
&comment=${_comment_}")

				printf "${f_b}BOT:${f_n}	${task_number}\n"
				otrs_number="$(curl -k -f -Ss  "${bot_api}/status.php?\
id=${task_number}&out=json" | sed 's/"//g; s/}//g' | \
awk '{split($0,a,"OtrsNum:"); print a[2]}')"
				printf "${f_b}OTRS:${f_n}	${otrs_number}\n"
				break
			fi
		done
	done
}

req_reboot()
{
	local _comment_="${1}"

	if [ "${host_ipmi}" = "True" ];
	then
		echo "Host ${_hostname_} has IPMI. You can use ipmitool for reboot \
this host.\n"
	else
		printf "${f_b}ACTION:${f_n}	Reboot request.\n"
		if [ "${sendmail_use}" = "True" ]; then
			sendmail -t <<EndOfMessage
From: ${email_from}
To: ${email_to}
Cc: ${email_cc}
Reply-To: ${email_replyto}
Subject: [${_host_dc_}/${_host_rack_}-${_host_rack_unit} : REBOOT : \
    ${_host_inv_number}] Перезагрузить машинку ${_hostname_}
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Добрый день.
Сервер ${_hostname_}.
Прошу перезагрузить аппарат по кнопке.
`
if [ "${boot}" = "net" ]; then
	echo -n "и загрузить его по сети"
elif [ "${boot}" = "bios" ]; then
	echo -n "и вывести его на биос"
fi
if [ -n "${_comment_}" ]; then
	echo "\nКомментарий:\n${_comment_}."
fi
`

Спасибо.

${signature}
EndOfMessage

		echo "Request sent via sendmail.\n"
		else
			task_number=$(curl -k -f -sS \
	    "${bot_api}/request.php?name=${_hostname_}&initiator=${initiator}&\
operation=reboot&boot=${boot}&oauth_token=${token}&email=yes&\
replyto=${email_replyto}&cc=${email_cc}&comment=${_comment_}")

			printf "${f_b}BOT:${f_n}	${task_number}\n"
			otrs_number="$(curl -k -f -Ss  "${bot_api}/status.php?id=\
${task_number}&out=json" | sed 's/"//g; s/}//g' | awk \
'{split($0,a,"OtrsNum:"); print a[2]}')"
			printf "${f_b}OTRS:${f_n}	${otrs_number}\n"
		fi
	fi
}

req_up()
{
	local _comment_="${1}"

	if [ "${host_ipmi}" != "True" ]
	then
		echo "This host has IPMI. You can use ipmitool for fix this problem\n"
	else
		printf "${f_b}ACTION:${f_n}	UP request.\n"
		sendmail -t <<EndOfMessage
From: ${email_from}
To: ${email_to}
Cc: ${email_cc}
Reply-To: ${email_replyto}
Subject: [${_host_dc_}/${_host_rack_}-${_host_rack_unit} : UP : \
    ${_host_inv_number}] Поднять машинку ${_hostname_} до логина.
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Добрый день.
Сервер ${_hostname_}.
Прошу поднять машинку до логина.
В случае неудачи, прошу вывести ее на биос и выдать КВМ.
`
if [ -n "${_comment_}" ]; then
	echo "\nКомментарий:\n${_comment_}."
fi
`

Спасибо.

${signature}
EndOfMessage

		echo "Request sent via sendmail.\n"
	fi
}

req_up_ipmi()
{
	local _comment_="${1}"

	if [ "${host_ipmi}" = "True" ] || [ "${force_mode}" = "True" ]; then
		printf "${f_b}ACTION:${f_n}	IPMI up request.\n"
		if [ -z "${problem}" ] || [ "${problem}" != "dns" ] &&
			[ "${problem}" != "nosignal" ] &&
			[ "${problem}" != "poweroff" ] &&
			[ "${problem}" != "ipmidown" ];
		then
			ipmi_problem="1"
		fi
		if [ "${problem}" = "ipmidown" ]; then
			ipmi_problem="108"
		elif [ "${problem}" = "dns" ]; then
			ipmi_problem="107"
		elif [ "${problem}" = "nosignal" ]; then
			ipmi_problem="106"
		elif [ "${problem}" = "poweroff" ]; then
			ipmi_problem="105"
		fi
		if [ "${sendmail_use}" = "True" ]; then
			if [ -z "${_comment_}" ]; then
				_comment_="Недоступен по IPMI. Просьба уделить ему внимание"
			fi
			sendmail -t <<EndOfMessage
From: ${email_from}
To: ${email_to}
Cc: ${email_cc}
Reply-To: ${email_replyto}
Subject: [${_host_dc_}/${_host_rack_}-${_host_rack_unit} : IPMI : \
    ${_host_inv_number}] Проблемы с IPMI ${_hostname_}.
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Добрый день.
Сервер ${_hostname_}.

Комментарий:
${_comment_}.

Спасибо.

${signature}
EndOfMessage

			echo "Request sent via sendmail.\n"
		else
			task_number=$(curl -k -f -sS \
	    "${bot_api}/request.php?name=${_hostname_}&initiator=${initiator}\
&operation=check_ipmi&problem=${ipmi_problem}&boot=${boot}&reboot=${reboot}\
&oauth_token=${token}&email=yes&replyto=${email_replyto}&cc=${email_cc}\
&needcall=${needcall}&comment=${_comment_}")

			printf "${f_b}BOT:${f_n}	${task_number}\n"
			otrs_number="$(curl -k -f -Ss  "${bot_api}/status.php?id=\
${task_number}&out=json"|sed 's/"//g; s/}//g' | \
awk '{split($0,a,"OtrsNum:"); print a[2]}')"
			printf "${f_b}OTRS:${f_n}	${otrs_number}\n"
		fi
	else
		echo "This host has not IPMI."
	fi
}

req_lan()
{
	local _comment_="${1}"
	printf "${f_b}ACTION:${f_n}	LAN request.\n"
	if [ -z "${problem}" ] || [ "${problem}" != "down" ] &&
		[ "${problem}" != "100mb" ] &&
		[ "${problem}" != "switchport" ];
	then
		problem="down"
	fi
	if [ "${sendmail_use}" = "True" ]; then
		if [ -z "${_comment_}" ]; then
			_comment_="Отсутствует сетевой линк. Посмотрите не \
отстегнулся ли кабель. При необходимости замените шнурок или переткните\
в другую сетевую карту"
		fi
		sendmail -t <<EndOfMessage
From: ${email_from}
To: ${email_to}
Cc: ${email_cc}
Reply-To: ${email_replyto}
Subject: [${_host_dc_}/${_host_rack_}-${_host_rack_unit} : LAN : \
    ${_host_inv_number}] Проблемы с сетью ${_hostname_}.
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Добрый день.
Сервер ${_hostname_}.

Комментарий:
${_comment_}.

Спасибо.

${signature}
EndOfMessage

echo "Request sent via sendmail.\n"
	else
		task_number=$(curl -k -f -sS \
	    "${bot_api}/request.php?name=${_hostname_}&initiator=${initiator}\
&operation=check_eth&problem=${problem}&boot=${boot}&reboot=${reboot}\
&oauth_token=${token}&email=yes&replyto=${email_replyto}&cc=${email_cc}\
&needcall=${needcall}&comment=${_comment_}")

		printf "${f_b}BOT:${f_n}	${task_number}\n"
		otrs_number="$(curl -k -f -Ss  "${bot_api}/status.php?\
id=${task_number}&out=json"|sed 's/"//g; s/}//g' |\
awk '{split($0,a,"OtrsNum:"); print a[2]}')"
		printf "${f_b}OTRS:${f_n}	${otrs_number}\n"
	fi
}

req_mem()
{
	local _comment_="${1}"

	if [ -z "${_comment_}" ]; then
		_comment_="Сбойную%20планку/планки%20определить%20не%20удалось.\
%20Прошу%20вас%20найти%20сбойную%20планку/планки%20и%20заменить"
	fi

	printf "${f_b}ACTION:${f_n}	Request for replacing memory.\n"
	if [ "${sendmail_use}" = "True" ]; then
		_comment_="$(echo "${_comment_}" | sed 's/%20/ /g')"
		sendmail -t <<EndOfMessage
From: ${email_from}
To: ${email_to}
Cc: ${email_cc}
Reply-To: ${email_replyto}
Subject: [${_host_dc_}/${_host_rack_}-${_host_rack_unit} : RAM : \
${_host_inv_number}] Сбойная память у машинки ${_hostname_}.
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Добрый день.
Сервер ${_hostname_}.
У машинки проблемы с памятью.

Комментарий:
${_comment_}.

Спасибо.

${signature}
EndOfMessage

		echo "Request sent via sendmail.\n"
	else
		task_number=$(curl -k -f -sS \
	    "${bot_api}/request.php?name=${_hostname_}&initiator=${initiator}\
&operation=memory&realmem=64&needmem=64&boot=${boot}&reboot=${reboot}\
&oauth_token=${token}&email=yes&replyto=${email_replyto}&cc=${email_cc}\
&needcall=${needcall}&comment=${_comment_}")

		printf "${f_b}BOT:${f_n}	${task_number}\n"
		otrs_number="$(curl -k -f -Ss  "${bot_api}/status.php?id=\
${task_number}&out=json"|sed 's/"//g; s/}//g' | \
awk '{split($0,a,"OtrsNum:"); print a[2]}')"
		printf "${f_b}OTRS:${f_n}	${otrs_number}\n"
	fi
}

req_psu()
{
	local _comment_="${1}"
	printf "${f_b}ACTION:${f_n}	PSU change request.\n"
	if [ "${sendmail_use}" = "True" ]; then
		sendmail -t <<EndOfMessage
From: ${email_from}
To: ${email_to}
Cc: ${email_cc}
Reply-To: ${email_replyto}
Subject: [${_host_dc_}/${_host_rack_}-${_host_rack_unit} : PSU : \
    ${_host_inv_number}] Заменить блок питания ${_hostname_}
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Добрый день.
Сервер ${_hostname_}.
Необходимо заменить блок питания.
`
if [ -n "${_comment_}" ]; then
	echo "\nКомментарий:\n${_comment_}."
fi
`

Спасибо.

${signature}
EndOfMessage

		echo "Request sent via sendmail.\n"
		else
			task_number=$(curl -k -f -sS \
	    "${bot_api}/request.php?name=${_hostname_}&initiator=${initiator}&\
operation=psu&boot=${boot}&email=yes&oauth_token=${token}&\
replyto=${email_replyto}&cc=${email_cc}&comment=${_comment_}")

			printf "${f_b}BOT:${f_n}	${task_number}\n"
			otrs_number="$(curl -k -f -Ss  "${bot_api}/status.php?id=\
${task_number}&out=json" | sed 's/"//g; s/}//g' | awk \
'{split($0,a,"OtrsNum:"); print a[2]}')"
			printf "${f_b}OTRS:${f_n}	${otrs_number}\n"
	fi
}


req_other()
{
	local _theme_="${1}"
	local _comment_="${2}"

	_theme_=$(echo ${_theme_} | iconv -t utf-8)
	printf "${f_b}ACTION:${f_n}	OTHER request.\n"

	sendmail -t <<EndOfMessage
From: ${email_from}
To: ${email_to}
Cc: ${email_cc}
Reply-To: ${email_replyto}
Subject: [${_host_dc_}/${_host_rack_}-${_host_rack_unit} : OTHER : \
${_host_inv_number}] ${_theme_} ${_hostname_}.
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Добрый день.
Сервер ${_hostname_}.

Комментарий:
${_comment_}.

Спасибо.

${signature}
EndOfMessage
	send_to_bot 7 START ${_hostname_} ${_theme_}
	send_to_bot 7 SUCCESS ${_hostname_} ${_theme_}
	echo "Request sent via sendmail.\n"
}

req_info()
{
	if [ -n "${_host_kvm_}" ]; then
		KVM="\n${f_b}KVM:${f_n} https://golem.yandex-team.ru/launch-kvm.sbml?\
kvm=${_host_kvm_}"
	elif [ "${host_ipmi}" = "True" ];
	then
		KVM="\n${f_b}IPMI:${f_n} https://${_hostname_}.ipmi.yandex-team.ru
${f_b}GOLEM:${f_n} https://golem.yandex-team.ru/launch-ipmi.sbml?h=${hostname}"
	fi

	printf "${f_b}PLACEMENT:${f_n} ${_host_dc_}/${_host_rack_}-\
${_host_rack_unit}\t\t${f_b}INVENTORY:${f_n} ${_host_inv_number}"
	printf "${KVM}\n"
	printf "${f_b}SWITCH:${f_n}	${_host_switch_}\t${f_b}PORT:${f_n} \
${_host_switch_port_}\t${f_b}VLAN:${f_n} ${_host_vlan_}\n"

#Fetching server info from bot.
	printf "\n${f_f}INFORMATION FROM BOT:${f_n}\n"
	curl -k -s "${bot_api}/consistof.php?name=${_hostname_}" |\
	    sed 's/<br*.\/>/\
/g; s/<.*>//g' | grep -v "${_hostname_}" |sed '/^$/d'

#Fetching information about storages from bot.
	for i in $(curl -k -s ${bot_api}/storages-by-serverinv.php?\
inv="${_host_inv_number}") ; do
#In first line of output contains information about connected storages.
#If to server connected storages, first line return "YES" and other lines
#return inv numbers of storages.
		if [ "${i}" = "NO" ]; then
			break
		elif [ "${i}" = "YES" ]; then
			printf "\n${f_f}SERVER STORAGES:${f_n}"
			storages_sum="0"
			continue
		fi
	storages_sum=`expr ${storages_sum} + 1` && \
		curl -k -s bot.yandex-team.ru/api/consistof.php?inv=${i} | \
		    sed 's/<br*.\/>//g; s/<.*>//g; s/Desc\.:/\
Desc\.:/';
	done

	if [ -n "${storages_sum}" ] && [ "${storages_sum}" -gt 0 ]; then
		printf "${f_f}TOTAL STORAGES:${f_n} ${storages_sum}\n\n\n"
		unset storages_sum
	else
		printf "\n\n"
	fi
}

req_actions()
{
#Now bot web-interface available only for users PC.
	curl -Ss -k --connect-timeout 2 -o /dev/null \
		"https://bot.yandex-team.ru" && bot_https_available="yes"
	if [ -z "${bot_https_available}" ]; then
		echo "BOT is not available now/here via https"
		exit 1
	fi

	printf '\033[1m%-10s %16s %18s %7s %12s %-15s\033[0m\n' \
ACTION DATE OTRS STATUS INITIATOR COMMENT
#Get all actions from bot frontend using looong awk filter.
	curl -s -k "https://bot.yandex-team.ru/adm/requestshow.php?Limit=30&\
Initiator=&OsName=${_hostname_}&token=${initiator}&oauth_token=${token}&export=file"| awk 'NR>=2 {gsub(/".$/, "\"; ");\
gsub(/; /,";\n"); gsub(/\"/,""); printf $0}' | \
awk -F";" '{printf "%-10s %16s %18s %7s %12s %-15s\n",$2,$5,$22,$21,$4,$6}'
}

manage_downtime()
{
	local _comment_="${1}"

	if [ "${downtime_time}" = "--remove" ]; then
		ssh -n jmon01.search.yandex.net "for host in ${hostlist}; do jctl remove \
		    downtime -host \$host && printf \"${f_b}SERVER:${f_n} \$host\n\
Downtime removed.\n\"; done"
		for host in ${hostlist}; do
			send_to_bot 6 CANCEL  ${host}
		done
	elif [ "${downtime_time}" = "--status" ]; then
		ssh -n jmon01.search.yandex.net "for host in ${hostlist}; do jctl list\
 downtimes -host \$host; done" | awk /HOST/'{split ($0,a,"|");\
print "\033[1mSERVER:\033[0m "a[1]"\nWas downtimed till:"a[6]"\t"a[7]}'
	else
		if [ -n "${_comment_}" ]; then
			description="-description '${_comment_}'"
		fi
		ssh -n jmon01.search.yandex.net "for host in ${hostlist}; do jctl add \
downtime -host \$host -stop +${downtime_time} ${description}; done" |\
		    awk /HOST/'{split ($0,a,"|");\
print "\033[1mSERVER:\033[0m "a[1]"\nAdded downtime to:"a[6]"\t"a[7]}'
		#Sending information to BOT
		for host in ${hostlist}; do
			send_to_bot 6 START  ${host} "Downtime on ${downtime_time}"
			send_to_bot 6 SUCCESS ${host}
		done
	fi
}

show_dc()
{
#obtain information about the location of host
	_hostname_="${1}"
	_column_arg_="${2}"
	curl -k -f -s "http://${_golem_server}/api/host_query.sbml"\
	    -d "hostname_list=${_hostname_}&columns=${_column_arg_}"

}

host_fqdn()
{
#Check host for FQDN. Append "Yandex.ru" or other in $domains if host in less
#than 2 points.
	local _hostname_="${1}"

	if echo ${_hostname_}|grep -q yandex.ru || [ $(echo ${_hostname_} | \
		    awk -F '.' '{print NF-1}') -ge 2 ]; then
		host_exist=$(curl -sk http://bot.yandex-team.ru/api/inv-by-name.php\
?name=${_hostname_} | head -1)
		if [ "${host_exist}" = "OK" ]; then
				hostname=${_hostname_}
		fi
	else
		for domain in ${domains}; do
			host_exist=$(curl -sk http://bot.yandex-team.ru/api/inv-by-name.php\
?name=${_hostname_}.${domain} | head -1)
			if [ "${host_exist}" = "OK" ]; then
				hostname=${_hostname_}.${domain}
			break
			fi
		done
	fi
	if [ -z ${hostname} ]; then
			printf "Cannot find real server FQDN for ${_hostname_}\n"
			continue
	fi
}

comment_to_ascii()
{
#Convert comment parameter to ascii string.
	comment=$(echo ${comment} | od -An -t xC | sed -E 's/[[:space:]]+/%/g; s/%$//'| tr -d '\n')
}

check_parameters()
{
	_hostargs_="${1}"
	_hostname_=$(echo ${_hostargs_} | awk '{print $1}')
	_host_rack_=$(echo ${_hostargs_} | awk '{print $2}')
	_host_rack_unit=$(echo ${_hostargs_} | awk '{print $3}')
	_host_inv_number=$(echo ${_hostargs_} | awk '{print $4}')
	_host_dc_=$(echo ${_hostargs_} | awk '{print $5}')
	_host_dc_short_=$(echo ${_hostargs_} | awk '{print $6}')
	_host_switch_=$(echo ${hostargs} | awk '{print $7}')
	_host_switch_port_=$(echo ${hostargs} | awk '{print $8}')
	_host_vlan_=$(echo ${hostargs} | awk '{print $9}')
	_host_kvm_=$(echo ${hostargs} | awk '{print $10}')
}

check_authorization()
{
#Check for existing token in home directory.
	token_path="${HOME}/.oauth_token"
	if [ -s "${token_path}" ] && [ -w "${token_path}" ] && \
		[ ! "${gen_token}" = "True" ]; then
		token=$(cat ${token_path})
	else
		printf "Authorization on OAUTH.\n"
		printf "user: ${initiator}\n"
		stty -echo
		read -p "password:" pass
		stty echo
		printf '\n'

		token_data=$(curl -k -sS -d "grant_type=password&username=\
${initiator}&password=${pass}&client_id=662aa591ebb04a999d2a4faa316a097a&client_secret=87224eb4ac514d2198e22b48166fc04c" https://oauth.yandex-team.ru/token)

		if $(echo ${token_data} | grep -q 'token'); then
			token=$(echo ${token_data} | sed 's/, /\
/g; s/"//g' | awk '{ if ( $1 ~ "access_token") {print $2}}')
			printf "Token is received and stored in ${token_path}\n"
			echo ${token} > ${token_path}

		elif $(echo ${token_data} | grep -q 'error'); then
			echo ${token_data} | sed 's/, /\
/g; s/"//g' | awk '{ if ( $1 ~ "error_description") { split ( $0, a, ":"); \
{ print "\033[1mERROR:\033[0m"a[2]}}}'

			exit 1
		fi
	fi
	eval token=${token}
}

send_to_bot()
{
	local _request_type_="${1}"
	local _status_="${2}"
	local _hostname_="${3}"
	local _comment_="${4}"

	request=$(curl -k -sS -d "oauth_token=${token}&initiator=${initiator}\
&requesttype=${_request_type_}&status=${_status_}&source=ADMIN&\
osname=${_hostname_}&comment=${_comment_}" \
bot.yandex-team.ru/api/scrm/import.php)
	if [ ! "${request}" = "OK" ]; then
		printf "Failed to send message to BOT\n"
	fi
}

check_bot_avalibility()
{
	curl -s -k -o /dev/null \
		"http://bot.yandex-team.ru" && bot_available="yes"
	if [ -z "${bot_available}" ]; then
		sendmail_use="True"
	fi
}

check_host_ipmi()
{
	local _hostname_="${1}"

	result=$(host ${_hostname_}.ipmi.yandex-team.ru 1>/dev/null; echo $?)
	if [ "${result}" = "0" ]; then
		host_ipmi="True"
	else
		host_ipmi="False"
	fi
}

help()
{
	less <<EndOfHelp
NAME
	$script_name - sends requests for helpdesk@ and displays information
	about host.

SYNTAX
	$script_name [-K][-R][-U][-M][-L][-S][-K][-I][-A][-P][-D <time>]
	[-H <slotnum>][-r][-f][-s][-l][-a][-b][-t theme][-c comment]
	[-p <problem>] <hostname>

	$script_name -h

DESCRIPTION
	Sends request to a given type on a special address. Can read hostlist
	from standart input.
	Script uses sendmail utility and BOT http-api to query. Also can send
	multiply requests, such as a request for KVM and reboot server. Requires
	oauth-authorization.

OPTIONS
	-K	This option sends request to KVM  for server. If specified host
		has ipmi, script shows link to IPMI-console. If KVM is already
		connected, script shows link to KVM-console.

	-H	Sends request to replace a disk. Requires an argument <slotnum>.
		For change disk in shelf need to specify serial number any disk in
		shelf using option -d.

	-R	Sends request to reboot a specific server. Blocks options -U, -M.
		But can use with option -H for hdd request and -l for networking
		boot.

	-P	Sends request to change power supply unit.

	-U	Sends request to up a specific server.

	-I	Sends request to host with IPMI problems. Problem can be specified
		using option -p.

	-L	Sends request to host with LAN problems. Problem can be specified
		using option -p.

	-M	Sends request to replace memory. You can sets bad memory module
		using option -c.

	-S	Shows information about host, its location and storages.

	-D	Adds downtime for host. Downtime can me removed with option
		--remove and look on downtime status with option --status.

	-A	Shows history of last actions with specified server.

	-c comment
		Adds a comment as argument. Can use with all options, but realy
		needed with option -M and without options.

	-r	"read only" mode for option -K. Shows already connected KVM or
		display message that request is needed.

	-f	"force" mode for option -K and -I. This option ignore any checks and
		run command.

	-d	Used with option -H for replace HDD in shelf request. Requires
		serial number of any disk in shelf.

	-l	Used with any BOT request for networking boot.

	-b	Used with any BOT request for boot into BIOS.

	-a	Used with any BOT request. Identifies the need for a telephone
		call before the action.

	-s	Sets type of request - sendmail. This option is useful when you
		want to create a request not with bot-api.

	-p	Clarifies lan problem. Used with -L or -I option. Requires specifying
		argument. List of available values:
		For lan problems:
			down,
			100mb,
			switchport.
		For IPMI problems:
			ipmidown,
			dns,
			nosignal,
			poweroff.

	-t theme
		Sets theme on other request.

	-g	Initiate generating oauth-token for using BOT handles.


EXAMPLES
	Sends request for reboot server ws10-000.yandex.ru:
		${script_name} -R ws10-000.yandex.ru

	Sends request for reboot servers ws10-000.yandex.ru, ws10-001.yandex.ru:
		${script_name} -R ws10-00{0,1}.yandex.ru

	Sends request for replace memory for ws10-000.yandex.ru:
		${script_name} -M -c CPU0DIMM1B ws10-000.yandex.ru

	Sends request for replace 1 from 0 disk for ws10-000.yandex.ru:
		${script_name} -H 1 ws10-000.yandex.ru

	Sends request for replace 10 from 0 disk in shelf for ws10-000.yandex.ru:
		${script_name} -H 10 -d 'HZRSGTEFS45' ws10-000.yandex.ru
	Where 'HZRSGTEFS45'	serial number of any disk in target shelf.

	Sends request for reboot server ws10-000.yandex.ru and boot from lan:
		${script_name} -Rl ws10-000.yandex.ru

	Sends request for reboot server ws10-000.yandex.ru and call before
	performing:
		${script_name} -Ra ws10-000.yandex.ru

	Sends request for show already connected KVM for list of hosts without
	send a request:
		printf "ws10-000\nws10-001\nws10-002" | ${script_name} -Kr

	Sends request for KVM and reboot server ws10-000.yandex.ru:
		${script_name} -KR ws10-000.yandex.ru

	Adds downtime for host ws10-000.yandex.ru to 2 days:
		${script_name} -D 2days ws10-000.yandex.ru

	Remove downtime for host ws10-000.yandex.ru:
		${script_name} -D --remove ws10-000.yandex.ru

	Sends request for make 1Gbit/s link instread of 100Mbit/s:
		${script_name} -Lp 100mb ws10-000.yandex.ru

	View information about host ws10-000.yandex.ru:
		${script_name} -S ws10-000.yandex.ru

	View information about actions with host ws10-000.yandex.ru:
		${script_name} -A ws10-000.yandex.ru




ADDITIONAL
	For use option -A, need to get role "responsible-admin" to link:
	https://idm.yandex-team.ru/?system=bot&type=role&role=responsible-admin

	If you need other than default values of the variables of sender or
	recipient, there are the following variables can be defined in their own
	environment:
	\${BOT_INITIATOR} - Rewrites author of ticket if system username is
	different from login@yandex-team.ru.

	\${BOT_EMAIL_FROM} - Allows you to override value of the variable
	\${email_from}.

	\${BOT_REPLY_TO} - Allows you to specify a list of email_replyto.

	\${BOT_CC} - Allows you to specify a list of email_cc.

	\${BOT_SIGNATURE} - Allows you to specify your signature.


Mar 25 2013

EndOfHelp
}

##GLOBAL VARIABLES
#################
initiator="${BOT_INITIATOR:-$(whoami)}"

#mail variables
email_from="${BOT_EMAIL_FROM:-${initiator}@yandex-team.ru}"
email_replyto="${initiator}@yandex-team.ru,${BOT_REPLY_TO:-search-maintenance@yandex-team.ru}"
email_cc="${initiator}@yandex-team.ru,${BOT_CC}"
email_to="helpdc@yandex-team.ru"


signature=""
signature="${BOT_SIGNATURE:---

http://staff.yandex-team.ru/${initiator}}
"

##LOCAL VARIABLES
###################
_golem_server=ro.admin.yandex-team.ru
script_name="$(basename ${0})"
bot_api="http://bot.yandex-team.ru/api"
gol_col="name,rack,warehouse_rack_unit,inventory_number,short_line,short_dc,\
switch,switch_port,primary_vlan,kvm"
#kvm_queues="eto[1-3]|iva[1-4]|myt[1-6]|ugr[1-4]"
domains="yandex.ru yandex.net search.yandex.net yt.yandex.net"


tmp="$(mktemp /tmp/request-XXXXX)"

#colors
f_b='\033[1m'
f_n='\033[0m'
f_ul='\033[4m'
f_f='\033[7m'

#PARSE OPTIONS
################

while getopts "hKH:RLUAPSMD:p:d:Isrgflbac:t:" opt; do
	case ${opt} in
	h)
		help
		exit 0
		;;
	K)
		kvm="True"
		;;
	H)
		hdd="True"
		slot="${OPTARG}"
		;;
	R)
		reboot="yes"
		;;
	P)
		psu_change="True"
		;;
	U)
		up="True"
		;;
	I)
		ipmi_unreach="True"
		;;
	L)
		lan="True"
		;;
	p)
		problem="${OPTARG}"
		;;
	M)
		memory="True"
		;;
	D)
		downtime="True"
		downtime_time="${OPTARG}"
		;;
	S)
		show_info="True"
		;;
	A)
		actions="True"
		;;
	r)
		read_only="True"
		;;
	f)
		force_mode="True"
		;;
	g)
		gen_token="True"
		;;
	s)
		sendmail_use="True"
		;;
	l)
		lan_boot="True"
		;;
	a)
		needcall="yes"
		;;
	b)
		bios_boot="True"
		;;
	d)
		shelf_hdd="True"
		shelf_disk_serial="${OPTARG}"
		;;
	c)
		comment="${OPTARG}"
		;;
	t)
		theme="${OPTARG}"
		;;
	\?)
		exit 1
		;;
	esac
done

shift $((${OPTIND} - 1))

#BASIC CHECKS
###############

#Ckeck for oauth-token
check_authorization

if [ "${gen_token}" = "True" ]; then
	exit 0
fi

if [ -z "${1}" ] && [ -t 0 ]; then
	cat <<EndOfUsage
Requires at least 1 parameter.
Usage:
${script_name} [-K][-R][-U][-M][-L][-S][-K][-I][-A][-P][-D <time>]
[-H <slotnum>][-r][-d][-f][-s][-l][-b][-a][-t theme][-c comment]
[-p <problem>] <hostname>

Use -h for additional help.
EndOfUsage
	exit 1
else
	hostlist="$*"
fi

#Check for boot mode
if [ "${lan_boot}" = "True" ] && [ -z "${bios_boot}" ]; then
	boot=net
elif [ "${bios_boot}" = "True" ] && [ -z "${lan_boot}" ]; then
	boot=bios
else
	boot=hdd
fi

#Check for reboot after requesting
if [ -z "${reboot}" ]; then
	reboot=no
fi

##SCRIPT BODY
###############
if [ ! -t 0 ]; then
	while read hostlist; do
		if [ -z "${hostlist}" ]; then
			continue
		else
			host_fqdn "${hostlist}"
		fi
		echo "${hostname}" | perl -pe 's/\033\[\d*(;\d*)*m//g' >> ${tmp}
	done
else
	for host in $(echo ${hostlist} | tr " " "\n"); do
		host_fqdn "${host}"
		echo "${hostname}" >> ${tmp}
	done
fi

if [ -n "${theme}" ] && [ -n "${comment}" ]; then
	sendmail_use="True"
fi

#Check for sets send method. If is not sendmail - check bot-api for availability.
if [ -z "${sendmail_use}" ]; then
	check_bot_avalibility
	if [ -n "${comment}" ]; then
		comment_to_ascii
	fi
fi

#Checking for host count and get information about hosts using Golem.
if [ $(cat ${tmp} | wc -l) -gt 1 ]; then
	show_dc "$(cat ${tmp} | tr '\n' ',' | sed 's/,$//')" ${gol_col} > ${tmp}
	cat ${tmp} | sort | awk \
	    '{print $1}END{print "\nYou want to send request for " NR \
	        " hosts \nPress Control-C to cancel\n"}'
	sleep 2
elif [ -s "${tmp}" ]; then
	show_dc "$(cat ${tmp})" ${gol_col} > ${tmp}
	if [ ! -s "${tmp}" ]; then
		cat ${tmp}
		echo "Host not in Golem. Please check."
		exit 1
	fi
else
	echo "No valid hostname present."
	exit 1
fi



#Checking for downtime action (mass action)
if [ -n "${downtime}" ]; then
	hostlist=$(cat ${tmp} | awk '{print $1}'| tr '\n' ' '| sed 's/ $//')
	manage_downtime "${comment}"
	exit 0
fi

#Checking for action per each host
while read hostargs; do
	check_parameters "${hostargs}"
	check_host_ipmi "${_hostname_}"
	printf "${f_b}SERVER:${f_n}	${_hostname_}\n"

	if [ -n "${kvm}" ]; then
		get_kvm "${comment}"
	elif [ -n "${hdd}" ] && [ -z "${shelf_hdd}" ]; then
		req_hdd "${slot}" "${comment}"
	elif [ -n "${hdd}" ] && [ -n "${shelf_hdd}" ]; then
		req_shelf_hdd "${slot}" "${shelf_disk_serial}" "${comment}"
	elif [ -n "${up}" ]; then
		req_up "${comment}"
	elif [ -n "${ipmi_unreach}" ]; then
		req_up_ipmi "${comment}"
	elif [ -n "${lan}" ]; then
		req_lan "${comment}"
	elif [ -n "${memory}" ]; then
		req_mem "${comment}"
	elif [ "${reboot}" = "yes" ]; then
		req_reboot "${comment}"
	elif [ -n "${psu_change}" ]; then
		req_psu "${comment}"
	elif [ -n "${show_info}" ]; then
		req_info
	elif [ -n "${actions}" ]; then
		req_actions
	else
		if [ -n "${theme}" ] && [ -n "${comment}" ]; then
			req_other "${theme}" "${comment}"
		else
			echo "For request need specify -t <theme> and -c <comment>."
		fi
	fi
	printf "\n"
done < ${tmp}

trap "rm ${tmp}" 0 1 2 15

exit 0
