#!/usr/bin/env python

import sys
import time
import urllib
import urllib2

class EventStatus:
    OK       = "ok"
    WARNING  = "warning"
    CRITICAL = "critical"

class Event:
    def __init__(self, object, name):
        self.object = object
        self.name   = name

def updateEvent(golemServer, event, status, description = "", timeoutSec = 5, numTries = 1):
    params = {
        "object":    event.object,
        "eventtype": event.name,
        "status":    status,
        "info":      description
    }

    failedTries = []

    for t in range(1, numTries + 1):
        if t > 0:
            # wait before retry
            time.sleep(1) 
        try :
            url = urllib2.urlopen(
                url = "http://" + golemServer + "/api/events/submit.sbml?" + urllib.urlencode(params),
                timeout = timeoutSec
            )
            response = url.read().strip(" \t\n")
            if response.startswith("ok"):
                return True
            else:
                failedTries.append("server response: " + response)

        except urllib2.URLError as urlError:
            try:
                errResponse = urlError.read()
                if status == EventStatus.OK and \
                   errResponse.startswith("error: no current event"):
                    return True 
                else:
                    failedTries.append("urllib2.URLError: %s (server response: %s)" % (urlError, errResponse))
            except:
                failedTries.append("urllib2.URLError: %s" % urlError)

        except urllib2.HTTPError as httpError:
            failedTries.append("urllib2.HTTPError: %s" % httpError)

        except Exception as e:
            failedTries.append("error: %s" % e)

    print >> sys.stderr, "failed tries"
    for (t, err) in enumerate(failedTries):
        print >> sys.stderr, "\t[%d] %s" % (t + 1, err)
    print >> sys.stderr, "failed to update {object: %s, event: %s, status: %s} at %s" % (event.object, event.name, status, golemServer)
    return False
