#!/usr/bin/env python
import urllib2
import simplejson
import sys,os
import golem

SRV = sys.argv[1]
SRV_URL = "http://%s/json?info=usage" % SRV
SERVER = SRV.split('.')[0].rstrip("[0-9]")
CONFIG = "/Berkanavt/mapreduce/config/quota_check.conf"

def read_config():
    selfpath = os.path.realpath(sys.argv[0])
    selfdir = os.path.dirname(selfpath)
    config_name = "/Berkanavt/mapreduce/config/quota_check.conf"
    with open(os.path.join(selfdir, config_name),"r") as f:
        config = simplejson.load(f)
        f.close()
    return config

GB = 1024**3
TB = 1024**4

def updateGolemEvents(user, current_usage, quota, warn_thresh, crit_thresh, golemConf):
    golemServer = golemConf["server"]
    objectName  = "%s-quota" % SERVER
    eventName = user

    eventDescription = "%s Current usage is %s Gb, Quota %s Gb" %(user, current_usage/GB, quota/GB)

    if current_usage > quota*crit_thresh :
        event_status = golem.EventStatus.CRITICAL
    elif quota*warn_thresh < current_usage < quota*crit_thresh :
        event_status = golem.EventStatus.WARNING
    else: 
        event_status = golem.EventStatus.OK

    try:
        golem.updateEvent(
            golemServer,
            golem.Event(
                objectName,
                eventName
            ),
            event_status,
            eventDescription,
            numTries = 5
        )
    except urllib2.URLError:
        pass

def getMRInfo(main_url):
    try:
        u_page = urllib2.urlopen(SRV_URL).read()
    except urllib2.URLError:
        print("Cannot connect to %s. exiting..." %SRV )
        exit(1)
    
    data_usage = {}
    usage = simplejson.loads(u_page)
    user_stat = usage['usage']['users']
    for i in user_stat:
        user = i['user']
        cu = i['currentUsage']
        quota = i['quota']
        if quota != 0:
           data_usage.update({user: {"cu": cu, "quota": quota}})
    return data_usage

def main():
    config = read_config()
    golemConf = config["golem"]
    data_usage = getMRInfo(SRV_URL)
    for user in data_usage:
        try:
            warn_thresh = float(config["users"][user].split(",")[0])/100.0
            crit_thresh = float(config["users"][user].split(",")[1])/100.0
        except KeyError:
            warn_thresh = 0.8
            crit_thresh = 0.9
            print "WARNING: User %s not defined in %s" % (user, CONFIG)
        current_usage = data_usage[user]['cu']
        quota = data_usage[user]['quota']

        updateGolemEvents(user, current_usage, quota, warn_thresh, crit_thresh, golemConf)
#        print(user, current_usage, quota, warn_thresh, crit_thresh, golemConf)

if __name__ == '__main__':
    main()
