#!/usr/bin/env python

import subprocess
import urllib2
import json
import time
import sys

SRV=sys.argv[1]
DEFAULT_PORT=""
SRV_URL = "http://%s/json?info=scheduler" % SRV
SERVER=SRV.split(':')[0]

AGAVESEND="/usr/bin/agavesend"
FSET="mr_scheduler_slots"
TITLE="'Scheduler statistic'"
WJOB_TITLE="'Waiting Jobs'"
OJOB_TITLE="'Orphan Jobs'"
WJOB_FSET="mr_waiting_jobs"
OJOB_FSET="mr_orphan_jobs"
STEP=60

try:
    s_page = urllib2.urlopen(SRV_URL).read()
except urllib2.URLError:
    print("Cannot connect to %s. exiting..." %SRV )
    exit(1)

sched = json.loads(s_page)
scheduler = sched['scheduler']

orphanJobs= scheduler['orphanJobs']
print("orphanJobs= %s" % orphanJobs)

box_name = "shared"
total_info = scheduler['totalInfo']
used_slot = total_info['slotsInUse']
free_slot = total_info['slotsFree']
total_slot = total_info['slotsTotal']

sort_params=""
try: 
    sort_info = scheduler['totalSortingInfo']
    sort_used_slot = sort_info['slotsInUse']
    sort_free_slot = sort_info['slotsFree']
    sort_total_slot = sort_info['slotsTotal']
    # Ugly hack MAPREDUCE-326
    if sort_used_slot > sort_total_slot:
        sort_used_slot = "0"
    if sort_free_slot > sort_total_slot:
        sort_free_slot = "0"
    print('Sort Slots in Use: %s') % sort_used_slot
    print('Sort Free Slots: %s') % sort_free_slot
    print('Sort Total Slots: %s') % sort_total_slot
# Temporary disabled due to problems on betula
    sort_params="Sort_Slots_In_Use:%s Sort_Free_Slots:%s\
 Sort_Total_Slots:%s" \
        % (sort_used_slot,sort_free_slot,sort_total_slot)
except KeyError:
    pass

try: 
    boxes = scheduler['boxList']
    for b in boxes:
       b_name = b['name']
       b_used_slot = b['totalInfo']['slotsInUse']
       b_free_slot = b['totalInfo']['slotsFree']
       b_total_slot = b['totalInfo']['slotsTotal']
       #print b_name
       #print b_used_slot
       #print b_free_slot
       #print b_total_slot
except KeyError:
        pass

print("BOX: %s") %box_name
print("Slots in Use: %s") % used_slot
print("Free Slots: %s") % free_slot
print("Total Slots: %s") % total_slot

waitjob_params=""

try:
    jobs_waitinig = scheduler['fairshareJobsWaiting']
    print("fairshareJobsWaiting: %s") % jobs_waitinig
    waitjob_params="--hostname %s --fieldset %s --title %s --values Jobs_Waitinig:%s\
 --template mr_scheduler --step %s"\
        %(SERVER,WJOB_FSET,WJOB_TITLE,jobs_waitinig,STEP)
    print waitjob_params
#    waitjob_params="Jobs_Waitinig:%s" % jobs_waitinig
    subprocess.Popen("%s %s" %(AGAVESEND,waitjob_params),
            stdout=subprocess.PIPE, shell=True).communicate()[0].rstrip()   
except KeyError:
    pass


params="--hostname %s --fieldset %s --title %s --values Slots_In_Use:%s\
 Free_Slots:%s Total_Slots:%s %s --template mr_scheduler --step %s"\
    %(SERVER,FSET,TITLE,used_slot,free_slot,total_slot,sort_params,STEP)

orphanJobs_params="--hostname %s --fieldset %s --title %s --values Orphan_Jobs:%s\
 --template mr_scheduler --step %s" %(SERVER,OJOB_FSET,OJOB_TITLE,orphanJobs,STEP)

#print params
subprocess.Popen("%s %s" %(AGAVESEND,params),
        stdout=subprocess.PIPE, shell=True).communicate()[0].rstrip()   
subprocess.Popen("%s %s" %(AGAVESEND,orphanJobs_params),
        stdout=subprocess.PIPE, shell=True).communicate()[0].rstrip()   
