#!/usr/bin/env python
# coding: utf-8

import urllib2
import json
import time,datetime
import sys,os
import smtplib

class Bunch:
    def __init__(self,*args,**kwds):
        if args:
            self.__dict__.update(args[0])
        else:
            self.__dict__.update(kwds)

SRV=sys.argv[1]
s_srv=SRV.split(".")[0]
VIEWER=''.join(i for i in s_srv if not i.isdigit()).strip(':')
SRV_URL = "http://%s/json?info=transactionlist" % SRV

def listtostr(list):
    retval = ""
    for e in list: retval+=e+", "
    retval.rstrip(" ,")
    return retval

def read_config():
    selfpath = os.path.realpath(sys.argv[0])
    selfdir = os.path.dirname(selfpath)
    config_name = "/Berkanavt/mapreduce/config/mr_transaction_time.cfg"
    with open(os.path.join(selfdir, config_name),"r") as f:
        config = json.load(f)
        f.close()
    return config

def sendMail(t_id,t_user,t_start,config):
    c_mail = config['mail_conf']
    c_users = config['users']
    work_limit = config['work_limit_days']
    smtp = smtplib.SMTP()

    try: user_mail=c_users[t_user]
    except KeyError: user_mail=c_users['other']
    addr = listtostr([user_mail,c_mail['maillist']]).rstrip(', ')
    to_list = addr.split(', ')
    #logging(msg_body,level="CHECK")
    # Convert unicode to ascii for mail body
    mfrom = c_mail['mfrom'].encode('ascii','ignore')
    addr = addr.encode('ascii','ignore')
    maillist = c_mail['maillist'].encode('ascii','ignore')
    t_id = t_id.encode('ascii','ignore')
    t_user = t_user.encode('ascii','ignore')
    msg = '''From: %s
To: %s
CC: %s
Content-Type: text/plain; charset="utf-8"
Subject: Trasnsaction %s is working too long

(English version is below)

Добрый день.

Транзакция %s
выполняется на кластере %s уже более %s дней. Возможно, это не является
ожидаемым поведением. Проверьте, пожалуйста.

Дополнительная информация:
Transaction id: %s
Started: %s
User: %s
(https://specto.yandex.ru/%s-viewer/transaction/%s/)

---------------------------

Hi!

Trasnsaction %s
is working more than %s days. Perhaps, it's not expected behavior.
Please, check it.

Additional information:
Transaction id: %s
Started: %s
User: %s
(https://specto.yandex.ru/%s-viewer/transaction/%s/)

''' % (mfrom, addr, maillist, t_id, t_id, VIEWER, work_limit, \
        t_id, t_start, t_user, VIEWER, t_id, t_id, work_limit, \
        t_id, t_start, t_user, VIEWER, t_id,)

#(https://specto.yandex.ru/%s/debug?info=transaction&transaction=%s)


    try:
        smtp.connect(c_mail['server'], 25)
        smtp.sendmail(c_mail['mfrom'],to_list,msg)
        smtp.quit()
        return True
    except:
        print("Cant send message!")
        return False

def getMRInfo(main_url,checkpoint):
    try:
        page = urllib2.urlopen(main_url).read()
    except urllib2.URLError:
        print("Cannot connect to %s. exiting..." %SRV )
        return False

    main = json.loads(page)
    tr_list = main['transactionInfo']['transactionList']
    transactions={}

    for t in tr_list:
        t_id = t['id']
        t_user = t['user']
        t_start = t['startTime']
        t_start = t_start/1000  #Temp fix for MAPREDUCE-278
        if t_start < checkpoint:
            start_time=datetime.datetime.fromtimestamp(t_start)
            transactions.update({t_id: {'user': t_user, 'start_time': start_time}})
    return transactions

def main():
    config = read_config()

    work_limit=config['work_limit_days']*(60*60*24) #days
    curr_time = int('%.0f' %time.time())
    checkpoint=curr_time-work_limit

    transactions = getMRInfo(SRV_URL,checkpoint)
    if transactions:
        for t in transactions:
            sendMail(t,transactions[t]['user'],transactions[t]['start_time'],config)


if __name__ == '__main__':
    main()
