#!/usr/local/bin/bash
#This script will find all interfaces in 100baseT mode and do "ifconfig $x media autoselect" 3 times
#if it could do this, write a email to seek-hw@yandex-team.ru
#
# created by themaf@yandex-team.ru



export PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/games:/usr/local/sbin:/usr/local/bin:/root/bin:/usr/local/share/bash
TMPFILE=$(mktemp /tmp/XXXXXX)
touch /tmp/check_gigabit
get_iface=$(ifconfig -l | tr " " "\n" | grep -v vlan > $TMPFILE)


if [ $(uname -r) = "7.2-STABLE" ]; then
		show_string='media:Ethernetautoselect(1000baseTX<full-duplex>)'
	else 
		show_string='media:Ethernetautoselect(1000baseT<full-duplex>)'
fi


show_status='status:active'


#It will get all interfaces with active link and write it to array ifaces[$_counter]

function get_iface_chanel {
_counter=0
for x in $(cat $TMPFILE); do
	get_media=`ifconfig $x | grep baseT | tr -d " " | tr -d "\t"`
	get_status=`ifconfig $x | grep status | tr -d " " | tr -d "\t"`
	if [ "$get_status" = "$show_status" ] && [ "$get_media" != "$show_string" ]; then
			ifaces[$_counter]="$x"; \
			_counter=$(($_counter + 1)); 
	fi
done
rm $TMPFILE
}



#This function will do "ifconfig $x media autoselect" with each bad interfaces
#If it hasn't fixed after 3 times, it will exit and set count to "3"

function media_autoselect {
local _counter=0
	for x in $1; do
		while [ $_counter -le 2 ]; do
			get_media=`ifconfig $x | grep baseT | tr -d " " | tr -d "\t"`
			get_status=`ifconfig $x | grep status | tr -d " " | tr -d "\t"`
			ifconfig $x media autoselect
			if [ "$get_media" != "$show_string" ]; then 
				_counter=$(( $_counter + 1 )); sleep 30;
			else 
				_counter="3"
				echo "0" > /tmp/check_gigabit
			fi
		done
	done
}



#This function will write name the interfaces, then hasn't fixed in bad_ifaces[$_counter]

function write_bad_ifaces {
if [ -z ${bad_ifaces[*]} ]; then
	echo "0" > /tmp/check_gigabit
fi


local _counter=0
	for x in ${ifaces[@]}; do
		get_media=`ifconfig $x | grep baseT | tr -d " " | tr -d "\t"`
		get_status=`ifconfig $x | grep status | tr -d " " | tr -d "\t"`
		if [ "$get_media" != "$show_string" ]; then 
			bad_ifaces[$_counter]="$x";  _counter=$(( $_counter + 1 ))
		fi
	done
}


#This finction will write a email to seek-hw@yandex-team.ru with list of interfaces; bad_ifaces[$_counter]

function send_the_email {
echo "1" > /tmp/check_gigabit
h=`hostname`
sendmail seek-hw@yandex-team.ru<<EOF
From: "$h" <devnull@yandex-team.ru>
To: seek-hw@yandex-team.ru
Subject: test mcheck gigabit in $h
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

Один или несколько "$*" интерфесов на хосте находятся не в режиме  1000baseT <full-duplex>.
Проверьте, пожалуйста.

-- 
$h
Сервер отдела поисковых систем департамента эксплуатации компании "Яндекс"
Тел.: +7 495 7397000
EOF
}


get_iface_chanel  
for x in ${ifaces[@]}; do
	media_autoselect "$x"
done

#DON'T DELETE SLEEP. 
sleep 30;
write_bad_ifaces
if [ -z ${bad_ifaces[*]} ]; then :
	else send_the_email ${bad_ifaces[*]}
fi
