# Author: Denis Korenevsky <denkoren@yandex-team.ru>
# This is a simple message "library" for printing messages to STDERROR
# They can be colorized, if client's terminal can represent colors

############################
#### "PUBLIC" VARIABLES ####
############################

# Are used to change functions behaviour from parent script.

# Verbose messages trigger
: ${msg_verbose_flag:=false}
# Debug messages trigger
: ${msg_debug_flag:=false}
# Warning messages trigger
: ${msg_warning_flag:=true}
# Error messages trigger
: ${msg_error_flag:=true}
# Critical messages trigger
: ${msg_critical_flag:=true}

#########################
#### LOCAL VARIABLES ####
#########################

if ! [ -t 1 ] \
    || ! [ -t 2 ]; then
	: ${_msg_Green:=''}
	: ${_msg_Cyan:=''}
	: ${_msg_Yellow:=''}
	: ${_msg_LRed:=''}
	: ${_msg_Normal:=''}
else
	case $TERM in
		xterm|screen*|*rxvt)
			: ${_msg_Green:='\033[00;32m'}
			: ${_msg_Cyan:='\033[00;36m'}
			: ${_msg_Yellow:='\033[00;33m'}
			: ${_msg_LRed:='\033[01;31m'}
			: ${_msg_Normal:='\033[00m'}
		;;
		*)
			: ${_msg_Green:=''}
			: ${_msg_Cyan:=''}
			: ${_msg_Yellow:=''}
			: ${_msg_LRed:=''}
			: ${_msg_Normal:=''}
		;;
	esac
fi

export \
    msg_verbose_flag \
    msg_debug_flag \
    msg_warning_flag \
    msg_error_flag \
    msg_critical_flag \
    _msg_Green \
    _msg_Cyan \
    _msg_Yellow \
    _msg_LRed \
    _msg_Normal

# Report an info message to STDERR (if msg_verbose_flag is set).
verbose()
{
	local _message_text

	_message_text="${*}"
	if $msg_verbose_flag; then
		printf -- \
		    "${_msg_Green}INFO:${_msg_Normal} ${_message_text}\n" >&2
	else
		return 1
	fi
}

# Report a debug message to STDERR (if msg_debug_flag is set).
debug()
{
	local _message_text

	_message_text="${*}"
	if $msg_debug_flag; then
		printf -- \
		    "${_msg_Cyan}DEBUG:${_msg_Normal} ${_message_text}\n" >&2
	else
		return 1
	fi
}

# Report a warning message to STDERR (if msg_warning_flag is set).
warning()
{
	local _message_text

	_message_text="${*}"
	if $msg_warning_flag; then
		printf -- \
		    "${_msg_Yellow}WARN:${_msg_Normal} ${_message_text}\n" >&2
	else
		return 1
	fi
}

# Report an error message to STDERR (if msg_error_flag is set).
error()
{
	local _message_text

	_message_text="${*}"

	if $msg_error_flag; then
		printf -- \
		    "${_msg_LRed}FAIL:${_msg_Normal} ${_message_text}\n" >&2
	else
		return 1
	fi
}

# Report a critical error to STDERR and exit.
critical()
{
	local _exitcode
	local _message_text

	_exitcode="${1}"
	shift
	_message_text="${*}"

	if $msg_error_flag; then
		printf -- \
		    "${_msg_LRed}CRIT:${_msg_Normal} ${_message_text}\n" >&2
	fi
	exit ${_exitcode}
}
