#!/bin/sh -e
#
# Making enviroment for report's makeup: SEEK-3955
# $Id$
#i
echo "enter you domain login"
read my_login
echo "login = $my_login"
installer="pkg_add -r"
if [ `uname -r | cut -d"." -f1`  -eq 9 ]
	then  installer="pkg install"
fi

if [ "$(id -u)" -ne 0 ]; then
        echo "You must be root"
        exit 1
fi

if [ `sysctl -n security.jail.jailed` -ne 1 ]; then
	echo "You aren't in jail"
	exit 1
fi

export PACKAGEROOT="http://distillatory.yandex.ru"

# Necessary packages.
necessary_packages="bash sudo node perl5.10 git libxslt rsync pam_mkhomedir gmake p5-JSON p5-Digest-SHA1 vim screen subversion p5-ack diablo-jre16 ruby javavmwrapper"

	for package in $necessary_packages
	do
	echo $installer $package
	$installer $package || true
	done

# XXX -- will be fixed in future.
#my_login=dbagimov

# XXX -- sync-from server
sync_server=luke4

# Getting luke4:/place/npm
rsync -av -e ssh ${my_login}@${sync_server}.yandex.ru:/place/npm /place/

# Getting luke4:/etc/profile
rsync -av -e ssh ${my_login}@${sync_server}.yandex.ru:/etc/profile /etc/

# Directory for yuicompressor.jar
mkdir -p /usr/local/share/yandex/

# Getting yuicompressor.jar (as child of /usr/local/share/yandex)
rsync -av -e ssh ${my_login}@${sync_server}.yandex.ru:/usr/local/share/yandex /usr/local/share/

# Getting ycssjs
rsync -av -e ssh ${my_login}@${sync_server}.yandex.ru:/usr/local/bin/ycssjs /usr/local/bin/

# Getting necessary Yandex's perl's modules.
rsync -av -e ssh ${my_login}@${sync_server}.yandex.ru:/usr/local/lib/perl5/site_perl/5.8.9/Yandex /usr/local/lib/perl5/site_perl/5.10.1/

# Necessary symlinks (SEEK-3955).
ln -s /usr/local/lib/libintl.so.9 /usr/local/lib/libintl.so.8
ln -s /lib/libcrypt.so.5 /lib/libcrypt.so.4

# Necessary symlinks (SEEK-5058).
for la in ControlPanel checkvms java java_vm javavm javaws jcontrol keytool manvm orbd pack200 policytool registervm rmid rmiregistry servertool tnameserv unpack200 unregistervm;
do ln -s /usr/local/bin/javavm $la;
done

# Getting necessary configuration file.
scp ${my_login}@${sync_server}://usr/local/etc/javavms /usr/local/etc/

# This symlink not used, added for compat with report's generator (SEEK-3955).
ln -s /usr/local/etc/rc.d/slb-utils /Berkanavt/webscripts/rcd/slb-utils

# Preparing for /place/hol -> /hol
mkdir /place/hol
ln -s /place/hol /hol

mkdir -p /hol/www/{logs,data}
chown -R www:www /hol/www
rm -rf /usr/local/www
ln -s /hol/www /usr/local/www
