#!/bin/sh -e
JAILNAME=$1
if [ -z $1 ]
then
    echo "usage ./mkjail.sh JAILNAME"
    exit
fi
echo "Create jail "$JAILNAME
ROOTHOST=`hostname` 
ROOTIP=`host $ROOTHOST | grep address | awk '{print $4}'`
JAILIP=`host ${JAILNAME}.yandex.ru | grep address | awk '{print $4}'`

for i in `ifconfig -l | tr [" "] ["\n"] | egrep -e 'em|bce|bge|igb'`;
do A=`ifconfig $i | grep status | awk -F: '{print $2}'`; 
    if [ "${A}" = " active" ];
    then 
        INTF=$i;
    fi;
done


echo $JAILIP
if [ $JAILIP = "213.180.193.24" ]
then
    echo "This jailname \"$JAILNAME\" is not reconized in dns"
    exit
fi

#if [ ! -e /boot/kernel/unionfs.ko ] 
#then
#    echo "Please, copy module unionfs.ko to /boot/kernel/" 
#    exit
#fi

mkdir -p /place/jail
mkdir -p /place/jail/$JAILNAME
[ "`mount | grep $JAILNAME`" != "" ] && umount /place/jail/$JAILNAME/place/hol 
chflags -R 0 /place/jail/$JAILNAME
rm -rf /place/jail/$JAILNAME/*
### Copy ROOT-System ###
cd /place/jail/$JAILNAME && dump -a -0 -f- / | restore -r -f- && rm restoresymtable
cd /place/jail/$JAILNAME/var && dump -a -0 -f- /var | restore -r -f- && rm restoresymtable
### Make some work direcotrys ###
for i in home coredumps hol vartmp; do mkdir -p /place/jail/$JAILNAME/place/$i; chmod 777 /place/jail/$JAILNAME/place/$i;done
### Add unionfs flags ###
#if [ "`grep unionfs_load /boot/loader.conf`" != 'unionfs_load="YES"'  ]  
#then
#    if [ -z "`grep unionfs_load /boot/loader.conf`" ]
#    then
#      echo 'unionfs_load="YES"' >> /boot/loader.conf
#    else
#      sed -e  's/unionfs_load.*/unionfs_load="YES"/' /boot/loader.conf > /boot/loader.conf.tmp && mv  /boot/loader.conf.tmp /boot/loader.conf 
#    fi
#fi
if [ -z "`grep "ListenAddress" /etc/ssh/sshd_config | grep -v ^#`" ]
then
    echo "ListenAddress $ROOTIP" >> /etc/ssh/sshd_config
else
    sed -i -e  "s/ListenAddress.*/ListenAddress $ROOTIP/" /etc/ssh/sshd_config 
fi
/etc/rc.d/sshd restart

if [ "`grep jail_enable /etc/rc.conf`" != 'jail_enable="YES"'  ]  
then
    if [ -z "`grep jail_enable /etc/rc.conf`" ]
    then
      echo 'jail_enable="YES"' >> /etc/rc.conf
      echo 'jail_socket_unixiproute_only="NO"' >> /etc/rc.conf
      echo 'jail_sysvipc_allow="YES"' >>  /etc/rc.conf
    else
      sed -i -e  's/jail_enable.*/jail_enable="YES"/' /etc/rc.conf 
    fi
fi

if [ "`grep nisdomainname /etc/rc.conf`" != 'nisdomainname="yandex-search"'  ]
then
	if [ -z "`grep nisdomainname /etc/rc.conf`" ]
	then
		echo 'nisdomainname="yandex-search"' >> /etc/rc.conf
	else
		sed -i -e  's/nisdomainname.*/nisdomainname="yandex-search"/' /etc/rc.conf 
	fi
	/etc/rc.d/nisdomain start
fi

sed -i -e 's/nosuid,//' /etc/fstab

if [ "`grep jail_${JAILNAME}_rootdir /etc/rc.conf`" != 'jail_${JAILNAME}_rootdir="/place/jail/${JAILNAME}"'  ]  
then
    if [ -z "`grep jail_${JAILNAME}_rootdir /etc/rc.conf`" ]
    then
              cat << EOF >> /etc/rc.conf
jail_${JAILNAME}_rootdir="/place/jail/${JAILNAME}"
jail_${JAILNAME}_devfs_enable="YES"
jail_${JAILNAME}_procfs_enable="YES"
jail_${JAILNAME}_exec_start="/bin/sh /etc/rc"
jail_${JAILNAME}_exec_stop="/bin/sh /etc/rc.shutdown"
jail_${JAILNAME}_hostname="${JAILNAME}.yandex.ru"
jail_${JAILNAME}_ip="${JAILIP}"
jail_${JAILNAME}_interface="$INTF"
EOF
    else
      perl  -e  '$JAILNAME=$ARGV[0];$JAILIP=$ARGV[1]; $INTF=$ARGV[2];open(A,"</etc/rc.conf") || die"can not open file rc.conf"; while(<A>){ s/jail_luke2_rootdir.*/jail_luke2_rootdir="\/place\/jail\/$JAILNAME"/;s/jail_${JAILNAME}_devfs_enable.*/jail_${JAILNAME}_devfs_enable="YES"/;s/jail_${JAILNAME}_procfs_enable.*/jail_${JAILNAME}_procfs_enable="YES"/;s/jail_${JAILNAME}_exec_start.*/jail_${JAILNAME}_exec_start="\/bin\/sh \/etc\/rc"/;s/jail_${JAILNAME}_exec_stop.*/jail_${JAILNAME}_exec_stop="\/bin\/sh \/etc\/rc.shutdown"/;s/jail_${JAILNAME}_hostname.*/jail_${JAILNAME}_hostname="${JAILNAME}.yandex.ru"/;s/jail_${JAILNAME}_ip.*/jail_${JAILNAME}_ip="${JAILIP}"/;s/jail_${JAILNAME}_interface.*/jail_${JAILNAME}_interface="$INTF"/;print; };close(A);' $JAILNAME $JAILIP $INTF > /etc/rc.conf.tmp  && mv  /etc/rc.conf.tmp /etc/rc.conf

      #sed -e  's/jail_enable.*/jail_enable="YES"/' /etc/rc.conf > /etc/rc.conf.tmp && mv  /etc/rc.conf.tmp /etc/rc.conf
    fi
fi

echo -e "ipaddr=\"${JAILIP}\"\nhostname=\"${JAILNAME}.yandex.ru\"" > /place/jail/${JAILNAME}/etc/rc.conf.local

#scp luke:/place/jail/luke1/etc/{rc.conf,rc,rc.shutdown} /place/jail/${JAILNAME}/etc/
sed -e  's/ListenAddress.*//' /place/jail/${JAILNAME}/etc/ssh/sshd_config > /place/jail/${JAILNAME}/etc/ssh/sshd_config.tmp && mv /place/jail/${JAILNAME}/etc/ssh/sshd_config.tmp /place/jail/${JAILNAME}/etc/ssh/sshd_config
#sed -e "s/127.0.0.1/${ROOTIP}/" /place/jail/${JAILNAME}/etc/resolv.conf > /place/jail/${JAILNAME}/etc/resolv.conf.tmp && mv /place/jail/${JAILNAME}/etc/resolv.conf.tmp /place/jail/${JAILNAME}/etc/resolv.conf
#cp /etc/resolv.conf /place/jail/${JAILNAME}/etc/
### Make resolv.conf ###
NETNUM=`. /etc/ya.subr;. /etc/rc.conf.local;export $(ya_network_info $ipaddr); printf %.3d $ya_net_num`;
host net-$NETNUM.porter.yandex.ru | awk 'BEGIN {print "domain  yandex.ru"} {print "nameserver\t"$4} END {print "nameserver\t77.88.26.253\noptions timeout:1 attempts:1"}'  > /tmp/resolv.conf 
if [ -s /tmp/resolv.conf ]
then 
	mv /tmp/resolv.conf /place/jail/${JAILNAME}/etc/
else
	cp /etc/resolv.conf /place/jail/${JAILNAME}/etc/
fi

sed -i -e 's/.*pam_mkhomedir.so.*/session         required        \/usr\/local\/lib\/pam_mkhomedir.so        mode=0755 debug/' /place/jail/${JAILNAME}/etc/pam.d/sshd
sed -i -e 's/.*radius.*/auth            sufficient  pam_radius.so       try_first_pass/' /place/jail/${JAILNAME}/etc/pam.d/sshd

RADIUSSERV=`host net-$NETNUM.porter.yandex.ru | awk '{print $4}' | xargs -I name host name | awk '{print $5}' | sed -e 's/.$//' | tr "\n" "," | sed -e 's/,$//'`

sed -i -e '/nis_client_flags.*/d' /place/jail/${JAILNAME}/etc/rc.conf
echo 'nis_client_flags="-s -m -S yandex-search,porter.yandex.ru,'${RADIUSSERV}' -ypset"' >> /place/jail/${JAILNAME}/etc/rc.conf

JN=`echo ${JAILNAME} | tr [a-z] [A-Z]` 
echo -e "+@${JN}:::::::::\n+:*:::::::/tmp/emptyhome:/sbin/nologin\n" >> /place/jail/${JAILNAME}/etc/master.passwd
pwd_mkdb -p -d /place/jail/${JAILNAME}/etc /place/jail/${JAILNAME}/etc/master.passwd


#chmod 444 /place/jail/${JAILNAME}/etc/rc.d/place
#mount -t unionfs -o below /place/hol /place/jail/${JAILNAME}/place/hol
echo "Copy /place/hol"
cd /place/hol; tar -cf - . | (cd /place/jail/${JAILNAME}/place/hol; tar -xpf -)
echo "Copy home-directory"
cd /place/home; tar -cf - . | (cd /place/jail/${JAILNAME}/place/home/; tar -xpf -)

#cd /place/usr_local_scripts; tar -cf - . | (mkdir -p /place/jail/${JAILNAME}/place/usr_local_scripts/;cd /place/jail/${JAILNAME}/place/usr_local_scripts/; tar -xpf -)
#mount -t unionfs /place/home /place/jail/${JAILNAME}/place/home
#[ "`grep ${JAILNAME} /etc/fstab | grep hol`" = "" ] && echo "/place/hol  /place/jail/${JAILNAME}/place/hol    unionfs below,rw  0   0" >> /etc/fstab

 cat << EOF > /etc/devfs.rules
[devfsrules_jail=4]
add include \$devfsrules_hide_all
add include \$devfsrules_unhide_basic
add include \$devfsrules_unhide_login
add path 'bpf*' unhide mode 0644
EOF

echo "Done"
