#!/bin/sh
#
# Monitoring lags of MySQL replication.
#
# $Id$

me=${0##*/}	# strip path
me=${me%.*}	# strip extension
BASE=$HOME/agents
PATH=/bin:/usr/bin:/usr/local/bin

#-- Subroutines --------------------------------------------------------

die()
{
	echo -e $1
	echo -e 0
	echo -e 0
	echo -e "second behind master"
	echo "PASSIVE-CHECK:$me;$2;$3"
	exit 0
}

check_depends()
{
	case "$check_enable" in
	[Yy][Ee][Ss]|[Tt][Rr][Uu][Ee]|[Oo][Nn]|1)
		;;
	*)
		die 0 0 "Check is disabled."
		;;
	esac

	if ! which -s mysql; then
		die 0 1 "mysql command not found !"
	fi
}


#-- Variables ----------------------------------------------------------

config="${BASE}/etc/${me}.conf"

check_enable="YES"

mysql_def_file="${HOME}/.my.cnf"
mysql_grp_sfx=""

sql_get_slave_status="SHOW SLAVE STATUS\G"


#-- Main ---------------------------------------------------------------

if [ -r "${config}" ]; then
	. ${config}
fi

check_depends

bsec=$(mysql --defaults-file="${mysql_def_file}" --defaults-group-suffix="${mysql_grp_sfx}" \
	-BAe "${sql_get_slave_status}" 2>/dev/null | \
	awk '$1 == "Seconds_Behind_Master:" {printf "%d", $2}')

if [ -z "$bsec" ]; then
	die 0 2 "Can't get Seconds_Behind_Master !"
fi

die $bsec 0 "${bsec}s."

