#!/bin/sh
#
# $Header$
#
# Monitoring last ${time_type} time for certain CM ${target}.
#
# Provides: erf_hostfactors

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/sbin:/usr/local/bin
export PATH

#-- Subroutines --------------------------------------------------------

die()
{
	echo "PASSIVE-CHECK:$self;$1;$2"
	exit 0
}

source_deps()
{
	if [ -r "${config}" ]; then
		. ${config}
	fi

	if [ -r "${robot_lib}" ]; then
		. ${robot_lib}
	else
		die 2 "Can't source ${robot_lib}!"
	fi
}

check_time()
{
	local _arg _time

	_arg="$1"
	if [ -z "${_arg}" ]; then
		die 2 "Internal error in check_time()"
	fi

	eval _time="\${${_arg}}"
	if [ -z "${_time}" ]; then
		die 2 "Can't get \`\`${_arg}'' time!"
	fi
}

get_diff_time()
{
	local _now _last_time

	_now=$(date +%s)
	check_time _now
	_last_time=$(get_target_times $target $time_type)
	check_time _last_time

	diff_time=$((${_now} - ${_last_time}))
	check_time diff_time
}

check_diff_time()
{
	if [ $diff_time -ge $crit_time ]; then
		die 2 "Last ${time_type} is ${diff_time}s ago"
	elif [ $diff_time -ge $warn_time ]; then
		die 1 "Last ${time_type} is ${diff_time}s ago"
	else
		die 0 "OK (last ${time_type} is ${diff_time}s ago)"
	fi
}

#-- Variables ----------------------------------------------------------

self=$(basename $0 .sh)
config="${HOME}/agents/${self}.conf"

robot_lib="/Berkanavt/webscripts/robot-common/common-start.sh"

cm_url="http://localhost:5133"
target="erf_hostfactors_calc_and_export"
time_type="success"
warn_time=$((24 * 60 * 60))		# seconds
crit_time=$((48 * 60 * 60))		# seconds

#-- Main ---------------------------------------------------------------

source_deps
get_diff_time
check_diff_time

