#!/bin/sh
#
# Script for monitoring modification time of specified tags.
#
# $Header$

PATH=/bin:/sbin:/usr/bin:/usr/sbin

me=${0##*/}		# strip path
me=${me%.*}		# strip extension
BASE=$HOME/agents
CONF=$BASE/etc/$me.conf

err_msg=""
os=$(uname -s | tr '[:upper:]' '[:lower:]')
now=$(date +%s)


#-- These variables are available for redefinition in config file ------
tag_list="robot yand"

robot_tag="/Berkanavt/dbspider/monitor/robot-merge-completed"
robot_threshold="3600"  # seconds
robot_err_msg_tpl="Robot merge is not completed in last %d sec."

yand_tag="/Berkanavt/dbspider/monitor/yand-merge-completed"
yand_threshold="7200"	# seconds
yand_err_msg_tpl="Yandex merge is not completed in last %d sec."


#-- Subroutines --------------------------------------------------------

die ()
{
	echo "PASSIVE-CHECK:$me;$1;$2"
	exit
}

check_depends()
{
	case "${os}" in
		freebsd|linux) ;;
		*) die 2 "Unsupported OS: ${os}.";;
	esac
}

check_tag()
{
	local _entry _tag _threshold _err_msg_tpl _err_msg _tag_mtime _stat_cmd

	_entry="$1"

	if [ -z "${_entry}" ]; then
		die 2 "Required function's argument is not defined !"
	fi

	eval _tag=\$${_entry}_tag
	eval _threshold=\$${_entry}_threshold
	eval _err_msg_tpl=\$${_entry}_err_msg_tpl

	if [ -z "${_tag}" -o -z "${_threshold}" -o -z "${_err_msg_tpl}" ]; then
		die 2 "Not all required variables are defined for ${_entry} entry !"
	fi

	case "${os}" in
		freebsd) _stat_cmd="stat -f %m" ;;
		linux) _stat_cmd="stat -c %Y" ;;
	esac
	_tag_mtime=$(${_stat_cmd} $_tag 2>/dev/null || echo 0)

	if [ $_tag_mtime -lt $(($now - $_threshold)) ]; then
		_err_msg=$(printf "${_err_msg_tpl}" $_threshold)
		err_msg="${err_msg}${err_msg:+ }${_err_msg}"

		if [ ${_tag_mtime} -eq 0 ]; then
			err_msg="${err_msg} Probably tag path (${_tag}) is incorrect."
		fi
	fi
}


#-- Main ---------------------------------------------------------------

[ -s $CONF ] && . $CONF

check_depends

# We keep $merges variable for backward compatibility
for entry in ${tag_list:-$merges}; do
	check_tag $entry
done

if [ -z "${err_msg}" ]; then
	die 0 "OK"
else
	die 2 "${err_msg}"
fi

