#!/bin/sh -eu
MYDIR=${0%/*}
MYSELF=${0##*/}
MYSELF=${MYSELF%%.*}

MYCNF="$HOME/.my.cnf"
CONFIG="$HOME/agents/etc/$MYSELF.conf"
CHECK_ENABLE=YES

WARN_PCT=80
CRIT_PCT=90

INSTANCES=""

test -r "$CONFIG" && . "$CONFIG"

test $WARN_PCT -gt 0
test $WARN_PCT -le $CRIT_PCT
test $CRIT_PCT -le 100

# used from parent process
global_ret () {
	printf "PASSIVE-CHECK:%s;%d;%s\n" $MYSELF $1 "${2:-Ok}"
	trap - 0
	exit 0
}

# used from childs
ret () {
	EXITCODE=$1
	shift
	test "$@" && echo "$INSTANCE: $@"
	trap - 0
	exit $EXITCODE
}

trap 'global_ret 2 "Runtime error"' 0

case $CHECK_ENABLE in
	[Yy][Ee][Ss]|[Oo][Nn]|[Tt][Rr][Uu][Ee]|1) : ;;
	*) global_ret 0 "Check disabled" ;;
esac

#
# parent process
#
test "${1:-}" || {
	GLOBAL_ERR=0
	test "$INSTANCES" || global_ret 0
	OUTPUT=""
	for INST in $INSTANCES
	do
		ERR=0
		OUT=$($0 $INST) || ERR=$?
		test "$OUT" && {
			test "$OUTPUT" && OUTPUT="$OUTPUT; $OUT" || OUTPUT="$OUT"
		}
		test $ERR -gt $GLOBAL_ERR && GLOBAL_ERR=$ERR
	done
	global_ret $GLOBAL_ERR "$OUTPUT"
}

#
# child process
#

trap 'ret 2 "Runtime error"' 0

INSTANCE=$1

exec_sql () {
	mysql --defaults-file="$MYCNF" --defaults-group-suffix="$INSTANCE" \
		-e "$1" -NBA 2>/dev/null
}

MAXCONN=$(exec_sql 'show global variables like "max_connections"') || ret 2 "Failed to get max_connections"
MAXCONN=$(echo $MAXCONN | awk '/^max_connections/{print $2}')
test "$MAXCONN" -gt 0 || ret 2 "Invalid max_connections"

WARN_ABS=$((WARN_PCT*(MAXCONN/100)))
CRIT_ABS=$((CRIT_PCT*(MAXCONN/100)))

THREADS_USED=$(exec_sql 'show global status like "Threads_connected"') || ret 2 "Failed to get mysql status"
THREADS_USED=$(echo $THREADS_USED | awk '/^Threads_connected/{print $NF}')
test "$THREADS_USED" || ret 2 "Incorrect used threads cnt"
test "$THREADS_USED" -le $MAXCONN || ret 2 "Current threads usage is greater than max connections allowed"
test "$THREADS_USED" -ge $CRIT_ABS && ret 2 "Used $THREADS_USED connections out of $MAXCONN"
test "$THREADS_USED" -ge $WARN_ABS && ret 1 "Used $THREADS_USED connections out of $MAXCONN"
ret 0 ''
