#!/bin/sh
#
# Check state of MySQL slave
#
# $Id$

me=${0##*/}	# strip path
me=${me%.*}	# strip extension
BASE=$HOME/agents
PATH=/bin:/usr/bin:/usr/local/bin

#-- Subroutines --------------------------------------------------------

die()
{
	echo "PASSIVE-CHECK:$me;$1;$2"
	exit 0
}

check_depends()
{
	case "$check_enable" in
	[Yy][Ee][Ss]|[Tt][Rr][Uu][Ee]|[Oo][Nn]|1)
		;;
	*)
		die 0 "Check is disabled."
		;;
	esac

	if ! which -s mysql; then
		die 1 "mysql command not found !"
	fi
}


#-- Variables ----------------------------------------------------------

config="${BASE}/etc/${me}.conf"

check_enable="YES"

mysql_def_file="${HOME}/.my.cnf"
mysql_grp_sfx=""

sql_get_slave_status="SHOW SLAVE STATUS\G"


#-- Main ---------------------------------------------------------------

if [ -r "${config}" ]; then
	. ${config}
fi

check_depends

eval $(mysql --defaults-file="${mysql_def_file}" --defaults-group-suffix="${mysql_grp_sfx}" \
	-BAe "${sql_get_slave_status}" 2>/dev/null | \
	awk -F':' '
		BEGIN{
			prop_found = 0
			io_running = 0
			sql_running = 0
		}
		$1 ~ /Slave_IO_Running/ {
			prop_found += 1
			if ($2 ~ /Yes/) io_running = 1
		}
		$1 ~ /Slave_SQL_Running/ {
			prop_found += 1
			if ($2 ~ /Yes/) sql_running = 1
		}
		END{
			printf "prop_found=%d;\n", prop_found
			printf "io_running=%d;\n", io_running
			printf "sql_running=%d;\n", sql_running
		}
	')

if [ $prop_found -ne 2 ]; then
	die 2 "\"${sql_get_slave_status}\" command execution failure or bad output !"
fi

if [ $io_running -ne 1 -o $sql_running -ne 1 ]; then
	die 2 "Slave not running (io: $io_running, sql: $sql_running) !"
fi

die 0 "Ok"

