#!/bin/sh
#
# $Id$
#
# Script for monitoring of orange instances.
#

me=${0##*/}		# strip path
me=${me%.*}		# strip extension
BASE=$HOME/agents
CONF=$BASE/etc/$me.conf

#-- Subroutines ---------------------------------------------------------

die ()
{
	echo "PASSIVE-CHECK:$me;$1;$2"
	exit
}

check_depends()
{
	if [ -z "${yr_group}" ]; then
		die 2 "yr group is not defined !"
	fi

	if $yr_cmd $yr_group LIST | grep -q "^$(hostname -s)$"; then
		return
	fi

	die 0 "Not used."
}

check_int_status()
{
	if ! cd $orange_dir; then
		die 2 "Can't change directory to ${orange_dir} !"
	fi

	if ! $orange_ctl $orange_ctl_args >/dev/null 2>&1; then
		die 2 "Daemon is not running !"
	fi
}

check_http()
{
	local _check_cmd

	case "$os" in
		freebsd) _check_cmd="fetch -qo /dev/null -T 15" ;;
		linux) _check_cmd="wget -qO /dev/null --timeout=15" ;;
		*) die 2 "Unsupported OS (${os}) !"
	esac

	if ! $_check_cmd $orange_check_url 2>/dev/null; then
		die 2 "Daemon is unreachable via HTTP !"
	fi
}


#-- Variables -----------------------------------------------------------

os=$(uname -s | tr '[:upper:]' '[:lower:]')

yr_cmd="/Berkanavt/bin/scripts/yr"
yr_group="+ORANGE_RUN +REALIDX +AFASTTIER +SALOON +SITESEARCH"

orange_dir="/Berkanavt/orange"
orange_ctl="${orange_dir}/release/start.py"
orange_ctl_args="-f orange.cfg --check"
orange_check_url="http://localhost:8080/metric"


#-- Main ----------------------------------------------------------------

[ -s $CONF ] && . $CONF

check_depends

check_int_status
check_http

die 0 "OK"

