#!/bin/sh
#
# $Id$
#
# Script for monitoring of sending logels
#

me=${0##*/}		# strip path
me=${me%.*}		# strip extension
BASE=$HOME/agents
CONF=$BASE/etc/$me.conf

send_logels_check_enable=1
send_logels_tag="/Berkanavt/orange/monitor/send_logels"
send_logels_threshold="5400"	# seconds
send_logels_err_msg="New logels has not been copied after %s."

ok_msg=""
err_msg=""
now=$(/bin/date +%s)

die ()
{
	echo "PASSIVE-CHECK:$me;$1;$2"
	exit
}

check_tag()
{
	local _name _check_enable _tag _threshold _err_msg _tag_mtime

	_name="$1"

	eval _check_enable=\$${_name}_check_enable
	eval _tag=\$${_name}_tag
	eval _threshold=\$${_name}_threshold
	eval _err_msg=\$${_name}_err_msg

	if [ $_check_enable -ne 1 ]; then
		ok_msg="Check disabled."
		return
	fi

	_tag_mtime=$(/usr/bin/stat -f '%m' ${_tag} 2>/dev/null || echo 0)
	if [ ${_tag_mtime} -lt $((${now} - ${_threshold})) ]; then
		if [ ${_tag_mtime} -eq 0 ]; then
			err_msg="Probably tag path (${_tag}) is incorrect."
		else
			err_msg=$(printf "${_err_msg}" "$(date -r ${_tag_mtime} '+%F %R')")
		fi
	fi
}

report()
{
	if [ -z "${err_msg}" ]; then
		die 0 "${ok_msg:-"OK"}"
	else
		die 2 "${err_msg}"
	fi
}


[ -s $CONF ] && . $CONF

check_tag send_logels
report

