#!/bin/sh
#
# $Id$
#
# Script for spiders monitoring
#

me=${0##*/}	# strip path
me=${me%.*}	# strip extension
BASE=$HOME/agents
CONF=$BASE/etc/$me.conf
TMP=$BASE/tmp
PATH=/bin:/sbin:/usr/bin:/usr/sbin

#-- Subroutines --------------------------------------------------------

die () {
	echo "PASSIVE-CHECK:$me;$1;$2"
	exit 0
}

#-- Variables (available for redefinition in config file) --------------

spider_url="http://localhost:8181/mon"
spider_check_counter="yes"
spider_counter="^KBytesTotal:"

err_log="$TMP/${me}.err"
count_log="$TMP/${me}.kbytes"
count_prev_log="$TMP/${me}.kbytes.prev"


#-- Main ---------------------------------------------------------------

[ -s $CONF ] && . $CONF

if [ -z "$(/Berkanavt/bin/scripts/spiderlookup -f)" ]; then
	die 0 "This spider is not used."
fi

eval "$(fetch -qo - ${spider_url} 2>${err_log} | \
	awk -v counter="${spider_counter}" '
	$1 ~ counter { printf "count=%d\n", $2; }
	')"

if [ -s "${err_log}" ]; then
	die 2 "$(cat ${err_log})"
fi

case "${spider_check_counter}" in
	[Yy][Ee][Ss])
		: ${count:=0}
		echo $count > $count_log
		if diff -q $count_log $count_prev_log >/dev/null 2>&1; then
			mv $count_log $count_prev_log
			die 2 "${me} is not downloading anything."
		fi
		mv $count_log $count_prev_log
		;;
esac

die 0 "Ok"

