#!/bin/sh

# Monitor squid process on +ASPIDER
# $Id$

PATH=/bin:/sbin:/usr/bin:/usr/sbin

me=${0##*/}     # strip path
me=${me%.*}     # strip extension
BASE=$HOME/agents
CONF=$BASE/etc/$me.conf


. /etc/rc.subr

[ -s ${CONF} ] && . ${CONF}

: ${pidfile:="/var/run/squid/squid.pid"}
: ${squid_port:="3128"}


log_exit () {
    printf "PASSIVE-CHECK:spider_squid;%d;%s\n" $1 "$2"
    exit $1
}

load_rc_config langnet

if [ -n "${langnet_ip}" ]
then
    _pid=$(check_pidfile ${pidfile} "squid-1")

    if [ -z $_pid ]
    then
        log_exit 2 "Squid is not running"
    fi

    sockstat -l -P tcp -p ${squid_port} | grep -q ${_pid}
    if [ $? -gt 0 ]
    then
        log_exit 2 "Squid is running, but not listen on port $squid_port"
    fi

    log_exit 0 "Squid is running, PID: ${_pid}"
fi

log_exit 0 "Squid is not required"
