#!/bin/sh
#
# $Id$
#
# Script for monitoring of MultiFormat Validator.
#

PATH=/bin:/usr/bin
export PATH

#-- Subroutines --------------------------------------------------------

die()
{
	echo "PASSIVE-CHECK:$me;$1;$2"
	exit 0
}

cleanup()
{
	rm -f $err_file 2>/dev/null || true
}


#-- Variables ----------------------------------------------------------

me=${0##*/}
me=${me%.*}

hostname=$(hostname -s)
port=14100

check_url="http://${hostname}:${port}/parse_url?url=http%3A%2F%2F${hostname}%3A${port}%2F"
timeout=15
ack_re="XML +result"

err_file=$(mktemp -t ${me})


#-- Main ---------------------------------------------------------------

trap cleanup EXIT

if ! fetch -qo - -T $timeout "${check_url}" 2>$err_file | \
	grep -qE "${ack_re}"
then
	err_str="$(cat ${err_file})"
	die 2 "CRIT${err_str:+: }${err_str}"
fi

die 0 "OK"

