#!/bin/sh
#
# $Id$
#
# Script for WMCDispatcher monitoring.
#

me=${0##*/}	# strip path
me=${me%.*}	# strip extension
BASE=$HOME/agents
TMP=$BASE/tmp
PATH=/bin:/sbin:/usr/bin:/usr/sbin


#-- Subroutines --------------------------------------------------------

die()
{
	echo "PASSIVE-CHECK:$me;$1;$2"
	exit 0
}

inc_configs()
{
	if [ -r "${wmc_cfg}" ]; then
		. $wmc_cfg
	else
		die 2 "WMC config $wmc_cfg not found !"
	fi

	if [ -r "${cmd_cfg}" ]; then
		. ${cmd_cfg}
	fi
}

add_to_crit_msg()
{
	crit_msg="${crit_msg}${crit_msg:+ }$*"
}

check_corba_mode()
{
	if [ ! -x "${pinger_cmd}" ]; then
		die 2 "Pinger is not found !"
	fi

	if ! $pinger_cmd -ORBInitRef NameService=${NAME_SERVICE} \
		--servant-ns-name=${WMC_NS_PATH}/WMCDispatcher${WMC_NS_SUFFIX} \
		>/dev/null 2>&1
	then
		add_to_crit_msg "CORBA dispatcher is broken."

	fi
}

check_http_mode()
{
	local _local_disp_url

	if [ ! -x "${pinger_http_cmd}" ]; then
		die 2 "HTTP Pinger is not found !"
	fi

	_local_disp_url=$(echo $WMCDISPATCHER_HTTP_LINK | \
		sed -Ee "s,//[^:]+:,//localhost:,")

	if ! $pinger_http_cmd --dispatcher-name=$_local_disp_url \
		--method=ping >/dev/null 2>&1
	then
		add_to_crit_msg "HTTP dispatcher is broken."
	fi
}

report()
{
	if [ -n "${crit_msg}" ]; then
		die 2 "${crit_msg}"
	else
		die 0 "Ok"
	fi	
}


#-- Variables ----------------------------------------------------------

wmc_cfg="/place/wmconsole/wmconsole.cfg"
cmd_cfg="${BASE}/etc/${me}.conf"

pinger_cmd="${BASE}/pinger"
pinger_http_cmd="${BASE}/pinger_http_disp"

scheme="all"	# (corba|http|all)


#-- Main ---------------------------------------------------------------

inc_configs

crit_msg=""

case "${scheme}" in
	corba|http)	check_${scheme}_mode ;;
	all)		check_corba_mode; check_http_mode ;;
	*)		die 2 "Unknown scheme !" ;;
esac

report

