#!/bin/sh
#
# $Id$
#
# Monitoring WMCHostmonLoader.
#

me=${0##*/}	# strip path
me=${me%.*}	# strip extension
BASE=$HOME/agents
TMP=$BASE/tmp
PATH=/bin:/sbin:/usr/bin:/usr/sbin


#-- Subroutines --------------------------------------------------------

die()
{
	echo "PASSIVE-CHECK:$me;$1;$2"
	exit 0
}

inc_configs()
{
	if [ -r "${wmc_cfg}" ]; then
		. $wmc_cfg
	else
		die 2 "WMC config $wmc_cfg not found !"
	fi

	if [ -r "${cmd_cfg}" ]; then
		. ${cmd_cfg}
	fi
}

add_to_crit_msg()
{
	crit_msg="${crit_msg}${crit_msg:+ }$*"
}

check_hostmonloader()
{
	local _local_hmon_url

	if [ ! -x "${pinger_cmd}" ]; then
		die 2 "Pinger is not found !"
	fi

	_local_hmon_url=$(echo $WMCHOSTMON_LOADER_HTTP_LINK | \
		sed -Ee "s,//[^:]+:,//localhost:,")

	if ! $pinger_cmd --hostmon-name=$_local_hmon_url >/dev/null 2>&1
	then
		add_to_crit_msg "HostmonLoader is broken."
	fi
}

report()
{
	if [ -n "${crit_msg}" ]; then
		die 2 "${crit_msg}"
	else
		die 0 "Ok"
	fi	
}


#-- Variables ----------------------------------------------------------

wmc_cfg="/place/wmconsole/wmconsole.cfg"
cmd_cfg="${BASE}/etc/${me}.conf"

pinger_cmd="${BASE}/pinger_http_hmon"


#-- Main ---------------------------------------------------------------

inc_configs

crit_msg=""

check_hostmonloader
report

